﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MassTransit.Model;
using System.Threading;

namespace MassTransit.Producer
{
    class Program
    {
        static void Main( string[] args )
        {
            System.Net.ServicePointManager.DefaultConnectionLimit = 100;

            int _t, _tc;
            ThreadPool.GetMinThreads( out _t, out _tc );
            ThreadPool.SetMinThreads( 100, _tc );

            var bus1 = ServiceBusFactory.New( sbc =>
            {
                sbc.UseRabbitMq(
                    f =>
                        f.ConfigureHost(
                            new Uri( "rabbitmq://guest:guest@localhost/masstransit_producer?prefetch=32" ),
                            c =>
                            {
                            } )
                    );

                sbc.UseJsonSerializer();
                sbc.ReceiveFrom( "rabbitmq://localhost/masstransit_producer?prefetch=32" );

                sbc.SetConcurrentConsumerLimit( 32 );

                sbc.DisablePerformanceCounters();
                sbc.SetCreateMissingQueues( true );
            } );

            while ( true )
            {
                Console.WriteLine( "Press key to publish message " );
                Console.ReadLine();

                bus1.Publish(
                    new ModelItem() { Name = DateTime.Now.ToString() }, 
                    typeof( ModelItem ),
                    pc => 
                    {
                        //pc.SetDeliveryMode( DeliveryMode.InMemory );
                        pc.SetWaitForAck( false );
                    } );

                Console.WriteLine( "Message sent" );
            }

            Console.WriteLine( "Finished" );
            Console.ReadLine();
        }
    }
}
