﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MassTransit.Model;

namespace MassTransit.Consumer
{
    class Program
    {
        static void Main( string[] args )
        {
            var bus1 = ServiceBusFactory.New( sbc =>
            {
                sbc.UseRabbitMq(
                    f =>
                        f.ConfigureHost(
                            new Uri( "rabbitmq://guest:guest@localhost/masstransit_consumer" ),
                            c =>
                            {
                            } )
                    );

                sbc.ReceiveFrom( "rabbitmq://localhost/masstransit_consumer" );
                sbc.SetConcurrentConsumerLimit( 10 );

                sbc.DisablePerformanceCounters();

                sbc.SetCreateMissingQueues( true );
            } );
            var consumer1 = new SimpleMessageItemConsumer();
            bus1.SubscribeConsumer( () => consumer1 );

            Console.WriteLine( "Listening to messages..." );
            Console.ReadLine();

            bus1.Dispose();
        }
    }

    public class SimpleMessageItemConsumer : Consumes<ModelItem>.All
    {
        #region All Members

        public void Consume( ModelItem message )
        {
            Console.WriteLine( "Message received : {0} at {1}", message.Name, DateTime.Now );
            System.Threading.Thread.Sleep( 3000 );
        }

        #endregion
    }

}
