// -------------------------------------
//
// -------------------------------------

#include <stdlib.h>
#include <string.h>

#include "transp.h"
#include "szachow.h"

class CSzachownica;

int pow2(char n)
{
  int i, j;
  for (i = 0, j = 1; i < n; i++, j*=2);
  return j;
}

CTranspTable::CTranspTable(char nbits)
{
  int i, j;

  int el_count = pow2(nbits);

  this->nbit = nbits;
  entries = new CTranspEntry[el_count];

  memset( entries, 0, el_count*sizeof(CTranspEntry) );

  for (i = 0; i < 8*8; i++)
    for (j = I_BPION; j <= I_CKROL; j++)
    {
      rand_num[j][i] = rand()%el_count;
      lock_num[j][i] = rand()%el_count;
    }

}

CTranspTable::~CTranspTable()
{
  if (entries) delete[] entries;
}

// zwroc index w tablicy transpozycji

int CTranspTable::TranspIndex(CSzachownica* szach)
{
  int index = 0;
  int i, j;
  char bierka;

  for (i=0; i<8; i++)
    for (j=0; j<8; j++)
      if (
           (bierka=szach->bierki[i][j]) != I_PUSTE
         )
        index ^= this->rand_num[bierka][i*8+j];

  return index;
}

// zwroc index w tablicy transpozycji

int CTranspTable::TranspLock(CSzachownica* szach)
{
  int index = 0;
  int i, j;
  char bierka;

  for (i=0; i<8; i++)
    for (j=0; j<8; j++)
      if (
           (bierka=szach->bierki[i][j]) != I_PUSTE
         )
        index ^= this->lock_num[bierka][i*8+j];

  return index;
}

void CTranspTable::ClearTable()
{
  int i;
  int el_count = pow2(nbit);

  for ( i=0; i<el_count; i++ )
    this->entries[i].used = 0;
}

void CTranspTable::StoreMove(int hk, int hl, EKolor kto_gra,
               int depth, CMoveInfo best)
{
  if (
       (
         this->entries[hk].used == 1 &&
         this->entries[hk].searchdepth < depth &&
         hl == this->entries[hk].lock
       )
       ||
       (
         this->entries[hk].used == 0
       )
     )
  {
    this->entries[hk].lock = hl;
    this->entries[hk].ktogra = kto_gra;
    this->entries[hk].searchdepth = depth;
    this->entries[hk].bestmove = best;
    this->entries[hk].used = 1;
  }
}

