#include "openbook.h"

const int ilosc_otwarc = 12;
extern int main_depth;
extern int INFTY;

// debiuty potwarte

CMoveInfo obrona_slowianska_A[] =
          {
            CMoveInfo("E2", "E4"),
            CMoveInfo("D7", "D5"),
            CMoveInfo("C2", "C4"),
            CMoveInfo("C7", "C6"),
            CMoveInfo("C4", "D5"),
            CMoveInfo("C6", "D5")
          };

CMoveInfo obrona_slowianska_B[] =
          {
            CMoveInfo("E2", "E4"),
            CMoveInfo("D7", "D5"),
            CMoveInfo("C2", "C4"),
            CMoveInfo("C7", "C6"),
            CMoveInfo("B1", "C3"),
            CMoveInfo("E7", "E6"),
            CMoveInfo("E2", "E4"),
            CMoveInfo("D5", "E4")
          };

CMoveInfo obrona_slowianska_C[] =
          {
            CMoveInfo("E2", "E4"),
            CMoveInfo("D7", "D5"),
            CMoveInfo("C2", "C4"),
            CMoveInfo("C7", "C6"),
            CMoveInfo("G1", "F3"),
            CMoveInfo("G8", "F6"),
            CMoveInfo("B1", "C3"),
            CMoveInfo("E7", "E6"),
            CMoveInfo("E2", "E3"),
            CMoveInfo("B8", "D7")
          };

CMoveInfo obrona_indyjska_A[] =
          {
            CMoveInfo("D2", "D4"),
            CMoveInfo("G8", "F6"),
            CMoveInfo("C2", "C4"),
            CMoveInfo("G7", "G6"),
            CMoveInfo("B1", "C3"),
            CMoveInfo("F8", "G7"),
            CMoveInfo("E2", "E4"),
            CMoveInfo("D7", "D6"),
            CMoveInfo("G1", "F3"),
            CMoveInfo("E8", "G8")
          };

CMoveInfo obrona_indyjska_B[] =
          {
            CMoveInfo("D2", "D4"),
            CMoveInfo("G8", "F6"),
            CMoveInfo("C2", "C4"),
            CMoveInfo("G7", "G6"),
            CMoveInfo("B1", "C3"),
            CMoveInfo("F8", "G7"),
            CMoveInfo("G2", "G3"),
            CMoveInfo("E8", "G8"),
            CMoveInfo("F1", "G2"),
            CMoveInfo("D7", "D6")
          };

CMoveInfo obrona_Nimzowitscha_A[] =
          {
            CMoveInfo("D2", "D4"),
            CMoveInfo("G8", "F6"),
            CMoveInfo("C2", "C4"),
            CMoveInfo("E7", "E6"),
            CMoveInfo("B1", "C3"),
            CMoveInfo("F8", "B4"),
            CMoveInfo("A2", "A3"),
            CMoveInfo("B4", "C3"),
            CMoveInfo("B2", "C3"),
            CMoveInfo("C7", "C5"),
            CMoveInfo("E2", "E3"),
            CMoveInfo("B8", "C6"),
            CMoveInfo("F1", "D3"),
            CMoveInfo("B7", "B6"),
            CMoveInfo("E3", "E4"),
            CMoveInfo("D7", "D6"),
            CMoveInfo("G1", "E2"),
            CMoveInfo("E6", "E5"),
            CMoveInfo("E1", "G1"),
            CMoveInfo("F6", "D7")
          };

CMoveInfo obrona_Nimzowitscha_B[] =
          {
            CMoveInfo("D2", "D4"),
            CMoveInfo("G8", "F6"),
            CMoveInfo("C2", "C4"),
            CMoveInfo("E7", "E6"),
            CMoveInfo("B1", "C3"),
            CMoveInfo("F8", "B4"),
            CMoveInfo("E2", "E3"),
            CMoveInfo("C7", "C5"),
            CMoveInfo("F1", "D3"),
            CMoveInfo("E8", "G8"),
            CMoveInfo("G1", "F3"),
            CMoveInfo("D7", "D5"),
            CMoveInfo("E1", "G1"),
            CMoveInfo("B8", "C6"),
            CMoveInfo("A2", "A3"),
            CMoveInfo("B4", "C3"),
            CMoveInfo("B2", "C3"),
            CMoveInfo("D5", "C4"),
            CMoveInfo("D3", "C4"),
            CMoveInfo("D8", "C7")
          };



// debiuty otwarte

CMoveInfo partia_szkocka[] =
          {
            CMoveInfo("E2", "E4"),
            CMoveInfo("E7", "E5"),
            CMoveInfo("G1", "F3"),
            CMoveInfo("B8", "C6"),
            CMoveInfo("D2", "D4"),
          };

CMoveInfo partia_wloska[] =
          { CMoveInfo("E2", "E4"),
            CMoveInfo("E7", "E5"),
            CMoveInfo("G1", "F3"),
            CMoveInfo("B8", "C6"),
            CMoveInfo("F1", "C4"),
            CMoveInfo("F8", "C5")
          };

CMoveInfo p_gambit_krolewski[] =
          { CMoveInfo("E2", "E4"),
            CMoveInfo("E7", "E5"),
            CMoveInfo("F2", "F4"),
            CMoveInfo("E5", "F4"),
            CMoveInfo("G1", "F3"),
            CMoveInfo("G8", "F6")
          };

CMoveInfo np_gambit_krolewski[] =
          { CMoveInfo("E2", "E4"),
            CMoveInfo("E7", "E5"),
            CMoveInfo("F2", "F4"),
            CMoveInfo("F8", "C5"),
            CMoveInfo("G1", "F3"),
            CMoveInfo("D7", "D6")
          };


CMoveInfo partia_hiszpanska[] =
          {
            CMoveInfo("E2", "E4"),
            CMoveInfo("E7", "E5"),
            CMoveInfo("G1", "F3"),
            CMoveInfo("B8", "C6"),
            CMoveInfo("F1", "B5"),
            CMoveInfo("A7", "A6"),
            CMoveInfo("B5", "C6"),
            CMoveInfo("D7", "C6"),
            CMoveInfo("E1", "G1"),
            CMoveInfo("C8", "G4"),
            CMoveInfo("H2", "H3"),
            CMoveInfo("H7", "H5"),
            CMoveInfo("D2", "D3"),
            CMoveInfo("D8", "F6"),
            CMoveInfo("C1", "E3"),
            CMoveInfo("G4", "F3"),
            CMoveInfo("D1", "F3"),
            CMoveInfo("F6", "F3"),
            CMoveInfo("G2", "F3"),
            CMoveInfo("F8", "D6")
          };

SOpenData OpenBook[] =
  { {6,  obrona_slowianska_A},
    {8,  obrona_slowianska_B},
    {10, obrona_slowianska_C},
    {10, obrona_indyjska_A},
    {10, obrona_indyjska_B},
    {20, obrona_Nimzowitscha_A},
    {20, obrona_Nimzowitscha_B},

    {5, partia_szkocka},
    {6, partia_wloska},
    {6, p_gambit_krolewski},
    {6, np_gambit_krolewski},
    {20, partia_hiszpanska}
  };

void WhaszujTabliceOtwarc(CTranspTable* transp)
{
  int i, j;
  int hk, hl;
  CSzachownica* pos = new CSzachownica();

  for (i=0; i<ilosc_otwarc; i++)
  {

    pos->UstawieniePoczatkowe();

    for (j=0; j<OpenBook[i].move_count; j++)
      {
        hk = transp->TranspIndex(pos);
        hl = transp->TranspLock(pos);

        transp->entries[hk].used = 1;
        transp->entries[hk].ktogra = pos->k_ruch;
        transp->entries[hk].searchdepth = INFTY;
        transp->entries[hk].bestmove = OpenBook[i].moves[j];
        transp->entries[hk].lock = hl;

        pos->PrzesunBierke(OpenBook[i].moves[j]);
        pos->PrzeciwnaStronaGra();

      };
  };

  delete pos;

}

