// -------------------------------------
//
// -------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "szachow.h"
#include "moves.h"

void print_errorMOVE(MoveStatus ms, char bufE[80])
{
  switch(ms) {
    case MOVE_BRAKBIERKI : sprintf(bufE, "There's no piece!");break;
    case MOVE_ZLYKOLOR : sprintf(bufE, "Wrong side!");break;
    case MOVE_WBREWZASAD : sprintf(bufE, "Against the rules for this piece!");break;
    case MOVE_JESTTAMBIERKA : sprintf(bufE, "Destination square is ocupied!");break;
    case MOVE_BIJEWLASNA : sprintf(bufE, "Can't grab an own pieces!");break;
    case MOVE_BRAKBICIA : sprintf(bufE, "Can't grab empty square!");break;
    case MOVE_NIEPRZESKAKUJ : sprintf(bufE, "Can't jump over pieces!");break;
    case MOVE_NIEROSZADAKROTKA : sprintf(bufE, "Can't do a ?!");break;
    case MOVE_NIEROSZADADLUGA : sprintf(bufE, "Can't do a ?!");break;
    case MOVE_BRONSZACHA : sprintf(bufE, "King is in jeopardy!");break;
    case MOVE_BRAKPRZELOTU : sprintf(bufE, "Can't do a ?!");break;
  }
}

// ---------------------------------------------------------------------

void Init_CzyscWszystko(char SValidMoves[IloscBierek][8*8][8*8])
{
  int i,j,k;
  for (k=0; k<IloscBierek; k++)
    for (i=0; i<8*8; i++)
      for (j=0; j<8*8; j++)
      {
        SValidMoves[k][i][j] = VM_RUCHNIEMOZ;
      }
}

// ---------------------------------------------------------------------
// PIONY

void Init_BPiony(char SValidMoves[IloscBierek][8*8][8*8])
{
  int i,j;
  // ruchy o jeden do przodu
  for (i=0; i<8; i++)
    for (j=0; j<7;j++)
    {
      SValidMoves[I_BPION][(j+1)*8+i][(j+2)*8+i] = VM_GDYWOLNE;
    }
  // poczatkowe ruchy o dwa do przodu
  for (i=0; i<8; i++)
    SValidMoves[I_BPION][8+i][3*8+i] = VM_GDYWOLNE;
  // bicia
  for (i=0; i<7; i++)
    for (j=0; j<7;j++)
    {
      SValidMoves[I_BPION][(j+1)*8+i][(j+2)*8+i+1] = VM_GDYWROGA;
    }
  for (i=1; i<8; i++)
    for (j=0; j<7;j++)
    {
      SValidMoves[I_BPION][(j+1)*8+i][(j+2)*8+i-1] = VM_GDYWROGA;
    }
  // bicia w przelocie
  for (i=0; i<7; i++)
  {
    SValidMoves[I_BPION][4*8+i  ][5*8+i+1] |= VM_PRZELOT;
    SValidMoves[I_BPION][4*8+i+1][5*8+i  ] |= VM_PRZELOT;
  }
}

void Init_CPiony(char SValidMoves[IloscBierek][8*8][8*8])
{
  int i,j;
  // ruchy o jeden do przodu
  for (i=0; i<8; i++)
    for (j=0; j<7;j++)
    {
      SValidMoves[I_CPION][(j+1)*8+i][j*8+i] = VM_GDYWOLNE;
    }
  // poczatkowe ruchy o dwa do przodu
  for (i=0; i<8; i++)
    SValidMoves[I_CPION][6*8+i][4*8+i] = VM_GDYWOLNE;
  // bicia
  for (i=0; i<7; i++)
    for (j=0; j<7;j++)
    {
      SValidMoves[I_CPION][(j+1)*8+i][j*8+i+1] = VM_GDYWROGA;
    }
  for (i=1; i<8; i++)
    for (j=0; j<7;j++)
    {
      SValidMoves[I_CPION][(j+1)*8+i][j*8+i-1] = VM_GDYWROGA;
    }
  // bicia w przelocie
  for (i=0; i<7; i++)
  {
    SValidMoves[I_CPION][3*8+i  ][2*8+i+1] |= VM_PRZELOT;
    SValidMoves[I_CPION][3*8+i+1][2*8+i  ] |= VM_PRZELOT;
  }
}

void Init_Skoczki(char SValidMoves[IloscBierek][8*8][8*8])
{
  int i, j, kier;               // pole, pole dest
  char c, cd;                   // kolumna, kol. dest
  for (i=0; i<8*8; i++)
  {
    c = i % 8;
    // dol i dwa prawo
    for (kier = 0; kier<8; kier++) // 8 kierunkw ruchu
    {
       switch(kier) {
         case 0 : j  = i+8+2;break;
         case 1 : j  = i+2*8+1;break;
         case 2 : j  = i+2*8-1;break;
         case 3 : j  = i+8-2;break;
         case 4 : j  = i-8+2;break;
         case 5 : j  = i-2*8+1;break;
         case 6 : j  = i-2*8-1;break;
         case 7 : j  = i-8-2;break;
       };
       cd = j%8;
       if (j>=0 && j<8*8 && (abs(c-cd)<3) )
       {
         SValidMoves[I_BSKOCZEK][i][j] =
         SValidMoves[I_CSKOCZEK][i][j] = VM_GDYWOLNE | VM_GDYWROGA;
       }
    }
  }
}

// wspolrzedne roszowan 'brk' = biala roszada krotka, itd.
const int br = 0*8+4;
const int brk = br + 2;
const int brd = br - 2;
const int cr = 7*8+4;
const int crk = cr + 2;
const int crd = cr - 2;

void Init_Krole(char SValidMoves[IloscBierek][8*8][8*8])
{
  int i, j, kier;               // pole, pole dest
  char c, cd;                   // kolumna, kol. dest
  for (i=0; i<8*8; i++)
  {
    c = i % 8;
    // dol i dwa prawo
    for (kier = 0; kier<8; kier++) // 8 kierunkw ruchu
    {
       switch(kier) {
         case 0 : j  = i+1;break;
         case 1 : j  = i+8+1;break;
         case 2 : j  = i+8;break;
         case 3 : j  = i+8-1;break;
         case 4 : j  = i-1;break;
         case 5 : j  = i-8-1;break;
         case 6 : j  = i-8;break;
         case 7 : j  = i-8+1;break;
       };
       cd = j%8;
       if (j>=0 && j<8*8 && (abs(c-cd)<2) )
       {
         SValidMoves[I_BKROL][i][j] =
         SValidMoves[I_CKROL][i][j] = VM_GDYWOLNE | VM_GDYWROGA;
       }
    }
  }
  // roszady
  SValidMoves[I_BKROL][br][brk] =
  SValidMoves[I_CKROL][cr][crk] = VM_ROSZADAK;
  SValidMoves[I_BKROL][br][brd] =
  SValidMoves[I_CKROL][cr][crd] = VM_ROSZADAD;
}

void Init_Gonce(char SValidMoves[IloscBierek][8*8][8*8])
{
  int i,j;

  // pn-zach <> pd-wsch
  for (i=0; i<8*8; i++)
    for (j=i-8*(8+1); j<i+8*(8+1); j+=9)
      if ( (j>=0) && (j<8*8) && (i!=j) )
        SValidMoves[I_BGONIEC][i][j] =
        SValidMoves[I_CGONIEC][i][j] = VM_GDYWOLNE | VM_GDYWROGA;

  // pn-wsch <> pd-zach
  for (i=1; i<8*8-1; i++)
    for (j=i-8*(8-1); j<i+8*(8-1); j+=7)
      if ( (i/8 != j/8) && (j>0) && (j<8*8-1) && (i!=j) )
        SValidMoves[I_BGONIEC][i][j] =
        SValidMoves[I_CGONIEC][i][j] = VM_GDYWOLNE | VM_GDYWROGA;
}

void Init_Wieze(char SValidMoves[IloscBierek][8*8][8*8])
{
  int i,j;

  for (i=0; i<8*8; i++)
  {
    // poziom
    for (j=(i/8)*8; j<(i/8)*8+8; j++)
      if (j!=i)
        SValidMoves[I_BWIEZA][i][j] =
        SValidMoves[I_CWIEZA][i][j] = VM_GDYWOLNE | VM_GDYWROGA;
    // pion
    for (j=i%8; j<8*8; j+=8)
      if (j!=i)
        SValidMoves[I_BWIEZA][i][j] =
        SValidMoves[I_CWIEZA][i][j] = VM_GDYWOLNE | VM_GDYWROGA;
  }
}

void Init_Hetmany(char SValidMoves[IloscBierek][8*8][8*8])
{
  int i,j;

  // pn-zach <> pd-wsch
  for (i=0; i<8*8; i++)
    for (j=i-8*(8+1); j<i+8*(8+1); j+=9)
      if ( (j>=0) && (j<8*8) && (i!=j) )
        SValidMoves[I_BHETMAN][i][j] =
        SValidMoves[I_CHETMAN][i][j] = VM_GDYWOLNE | VM_GDYWROGA;

  // pn-wsch <> pd-zach
  for (i=1; i<8*8-1; i++)
    for (j=i-8*(8-1); j<i+8*(8-1); j+=7)
      if ( (i/8 != j/8) && (j>0) && (j<8*8-1) && (i!=j) )
        SValidMoves[I_BHETMAN][i][j] =
        SValidMoves[I_CHETMAN][i][j] = VM_GDYWOLNE | VM_GDYWROGA;

  for (i=0; i<8*8; i++)
  {
    // poziom
    for (j=(i/8)*8; j<(i/8)*8+8; j++)
      if (j!=i)
        SValidMoves[I_BHETMAN][i][j] =
        SValidMoves[I_CHETMAN][i][j] = VM_GDYWOLNE | VM_GDYWROGA;
    // pion
    for (j=i%8; j<8*8; j+=8)
      if (j!=i)
        SValidMoves[I_BHETMAN][i][j] =
        SValidMoves[I_CHETMAN][i][j] = VM_GDYWOLNE | VM_GDYWROGA;
  }
}

// ---------------------------------------------------------------------

// wypelnia tablice poprawnych ruchow SValidMoves
// struktura SOpisRuchu SValidMoves[IloscBierek][8*8][8*8];
// zawiera opisy indeksowane : numerem bierki, numerem pola zr i
// numerem pola docelowego

void COpisRuchu::Init()
{
  Init_CzyscWszystko(this->SValidMoves);

  Init_BPiony(this->SValidMoves);
  Init_CPiony(this->SValidMoves);
  Init_Skoczki(this->SValidMoves);
  Init_Krole(this->SValidMoves);
  Init_Gonce(this->SValidMoves);
  Init_Wieze(this->SValidMoves);
  Init_Hetmany(this->SValidMoves);
}


