#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "eval.h"
#include "moves_n.h"

#define TASSERT(p) if (p == NULL) MessageBox(NULL, "p == NULL", "", MB_OK) 

// prosty ewaluator pozycji na szachownicy
// docelowo powinien przyjmowag wektor wag
// n-elementowy, ktory wyznaczalby wagi poszczegolnych
// ocenianych elementow dla bialych (dla czarnych to samo by sie
// odejmowalo

#define cm  1         // wspolczynnik oddalenia od krola
#define pp  2         // oddalenie pionw od lini przemiany
#define dp  20        // kara za podwojne piony w kolumnie
#define nsp 30        // nagroda za samodzielnego piona w kolumnie
#define nsw 50        // nagroda za samodzielne wieze
#define kk  15         // kara za konika na brzegach
#define pion 100
#define wieza 512
#define skoczek 310
#define goniec 308
#define hetman 914

extern HWND hwnd;
extern int main_depth;
extern int boardPosX;
extern int boardPosY;
extern BITMAP bm;
int CEwaluator::pos_count = 0;
char buf[80];

int CEwaluator::Eval(CSzachownica* szach, COpisRuchu* orh)
{
  int i,j;
  int bp, cp;   // biale, czarne piony

  int res = 0;
//  return rand()%100-50;

  int bk, ck, bKrol, cKrol;

  bKrol = szach->ZnajdzWspolrzedneKrolaEval(C_BIALE);
  cKrol = szach->ZnajdzWspolrzedneKrolaEval(C_CZARNE);

  // nigdy nie wpusci tutaj pozycji bez krola bo je wczesniej uznaje za
  // niepoprawne! jak wiec ocenic czy jest szach lub mat?

  // 1. zlicz wartosc bierek
  // 2. licz odleglosc bierek czarnych od bialego krola
  //    a bialych od czarnego
  // 4. ukaraj za podwojne piony
  // 5. ukaraj koniki na brzegach
  // 6. nagradzaj otwarte linie wiez
  // 7. nagradzaj piony ktore nie maja pionow przeciwnika na lini


  for (i=0; i<8; i++)
    for (j=0; j<8; j++)
    {
      if (szach->bierki[i][j] != I_PUSTE)
      {
        bk = cm * (abs(i-bKrol/8) + abs(j-bKrol%8));
        ck = cm * (abs(i-cKrol/8) + abs(j-cKrol%8));
      }

      switch(szach->bierki[i][j]) {
      case I_BPION : res += pion;
                     res += pp * i;     // odleglosc od lini przemiany
                     break;

      case I_CPION : res -= pion;
                     res -= pp * (7-i);
                     break;

      case I_BWIEZA : res += wieza;
                      res -= ck;
                      break;

      case I_CWIEZA : res -= wieza;
                      res += bk;
                      break;

      case I_BSKOCZEK : res += skoczek;
                        res -= ck;
                        break;

      case I_CSKOCZEK : res -= skoczek;
                        res += bk;
                        break;

      case I_BGONIEC : res += goniec;
                       res -= ck;
                       break;

      case I_CGONIEC : res -= goniec;
                       res += bk;
                       break;

      case I_BHETMAN : res += hetman;
                       res -= ck;
                       break;

      case I_CHETMAN : res -= hetman;
                       res += bk;
                       break;

      };
    }

  // 4
  for (i=0; i<8; i++)
  {
    bp = cp = 0;
    for (j=0; j<8; j++)
    {
      if (szach->bierki[j][i] == I_BPION)
        bp++;
      if (szach->bierki[j][i] == I_CPION)
        cp++;
    }
    if (bp > 1) res -= dp;
    if (cp > 1) res += dp;
  }

  // 5
  for (i=0; i<8; i++)
    for (j=0; j<8; j++)
      if (
           (i<2) || (i>5) ||
           (j<2) || (j>5)
         )
      {
        if (szach->bierki[i][j] == I_BSKOCZEK)
          res -= kk;
        if (szach->bierki[i][j] == I_CSKOCZEK)
          res += kk;
      }

  // 6
  for (i=0; i<8; i++)
  {
    // biale wieze
    bp = cp = 0;
    for (j=0; j<8; j++)
    {
      if (szach->bierki[j][i] == I_BWIEZA)
        bp++;
      if (
           szach->bierki[j][i] != I_PUSTE &&
           szach->bierki[j][i] != I_BWIEZA
         )
        cp++;
    }
    if ( (bp >= 1) && (cp == 0) ) res += bp*nsw;
    // czarne
    bp = cp = 0;
    for (j=0; j<8; j++)
    {
      if (szach->bierki[j][i] == I_CWIEZA)
        cp++;
      if (
           szach->bierki[j][i] != I_PUSTE &&
           szach->bierki[j][i] != I_CWIEZA
         )
        bp++;
    }
    if ( (cp >= 1) && (bp == 0) ) res -= cp*nsp;
  }

  // 7
  for (i=0; i<8; i++)
  {
    bp = cp = 0;
    for (j=0; j<8; j++)
    {
      if (szach->bierki[j][i] == I_BPION)
        bp++;
      if (szach->bierki[j][i] == I_CPION)
        cp++;
    }
    if ( (bp == 1) && (cp == 0) ) res += nsp;
    if ( (cp == 1) && (bp == 0) ) res -= nsp;
  }

  return (szach->k_ruch == C_BIALE ? res : -res);

}

// AlphaBeta

CMoveInfo CEwaluator::AlphaBeta(CNode* node,
                              COpisRuchu* orh,
                              CTranspTable* trans,
                              int depth,
                              int alpha, int beta,
                              CMoveInfo *tryFirst)
{
  int nr, tryFirstIndex;
  bool sapoprawnedzieci;

  CMoveInfo value, best, pl;    // pl - pierwszy lepszy. i tak bedzie mat

  CNode* succ, *tmp;
  CSzachownica *tmpel;
  CSzachownica *pos = (CSzachownica*)node->el;

  // najpierw siegniecie do TranspTable
  int hk = trans->TranspIndex(pos);
  int hl = trans->TranspLock(pos);

  // to jeszcze wymaga sprawdzenia!
  if (
       (trans->entries[hk].used == 1) &&
       (trans->entries[hk].ktogra == pos->k_ruch) &&
       (trans->entries[hk].lock == hl)   &&
       (trans->entries[hk].searchdepth >= depth)
     )
     if (
          pos->CzyRuchPoprawny(trans->entries[hk].bestmove,
          orh, true, false) == MOVE_OK
        )
        return trans->entries[hk].bestmove;

  // juz licz
  best.val = -INFTY;

  if (depth == 0)
  {
    value = pos->pm;
    value.val = this->Eval(pos, orh);

    return value;
  }

  succ = KolejneRuchy(pos, orh, false);
  
  int chil = succ->CountChildren();

  // iterative deepening sort!

  if ( tryFirst != NULL )
  {
    tryFirstIndex = -1;
    tmp = succ->children;
    for (nr = 0; nr< chil; nr++)
    {
      if (
           ((CSzachownica*)(tmp->el))->pm == *tryFirst
         )
         tryFirstIndex = nr;
  
      tmp = tmp->next;
    }

    if (tryFirstIndex!=-1) succ->PushChildToHead(tryFirstIndex);

  }

  // iteracja przez kolejne dzieciaki
  tmp = succ->children;
  sapoprawnedzieci = false;
  int bro = 0;

  // tutaj iteracja przez kolejne dzieciaki
  while (
          (tmp != NULL) && (best.val < beta)
        )
  {
    tmp->parent = node;
    tmpel = (CSzachownica*)tmp->el;

    pos_count++;
    bro++;

    // OUTPUT numeru posuniecia
    if (depth == main_depth)
    {
       HDC hdc = GetDC(hwnd);
       sprintf(buf, "%d/%d    ", bro, chil);
       SetBkColor( hdc, GetSysColor(COLOR_BTNFACE) );
       TextOut( hdc, boardPosX + 15, 
                     boardPosY+10+8*bm.bmHeight + 2 + 15, 
                     buf, strlen(buf) );
       DeleteDC(hdc);
    }

    // najpierw sprawdz czy nie zbito krola, czy to poprawny ruch
    // tylko ze az dwa pokolenia wstecz, nie jedno
    int ik = tmpel->ZnajdzWspolrzedneKrola(true);
    if (ik == -1)
    {
      succ->RemoveChildren();  // nie odkladaj tego do transp table
      delete succ; 
      node->poprawny = false;
      return best;
    }
    else
    {

      if (best.val > alpha) alpha = best.val;
      value = this->AlphaBeta(tmp, orh, trans, depth - 1,
                              -beta, -alpha, NULL);
      value.val = -value.val;

      // teraz wlasciwy a-b

      // jesli w czasie poszukiwan stwierdzono, ze tak nie wolno ruszac
      // to omin te pozycje

      if (tmp->poprawny == false)
      {
        tmp = tmp->next;
        continue;
      }
      else
      {
        // sa poprawne dzieci
        sapoprawnedzieci = true;

        // znaleziono lepsze posuniecie
        if ( value.val > best.val )
        {

          // maly output tylko kiedy lepsze!
          if (depth == main_depth)
          {
            HDC hdc = GetDC(hwnd);
            sprintf(buf, "   %c%c-%c%c... %6d",
                    65+tmpel->pm.ys, 49+tmpel->pm.xs,
                    65+tmpel->pm.yd, 49+tmpel->pm.xd,
                    value.val);
                    
            SetBkColor( hdc, GetSysColor(COLOR_BTNFACE) );
            SetTextAlign( hdc, TA_RIGHT );
            TextOut( hdc, boardPosX+10+8*bm.bmWidth - 15, 
                          boardPosY+10+8*bm.bmHeight + 2 + 15, 
                          buf, strlen(buf) );        
            DeleteDC(hdc);        
          }

          best = tmpel->pm;      // poprzedni ruch z poziomu wywolania
                                 // powinien pamietac na co promowac!
          best.val = value.val;  // najlepsza wartosc przenosi sie z poz. 0

        } // if value.best >

      } // if tmp->.poprawny == true

    } // if ik==-1

    tmp = tmp->next;
  }

  succ->RemoveChildren();
  delete succ;
  succ = NULL;

  if ( sapoprawnedzieci == false )
  {
    // jesli nie ma poprawnych ruchow przeciwnika, to
    // zalezy, czy jest to szach czy pat!
    best = pos->pm;
    if ( pos->CzyJestSzach(orh) )
        best.val = -INFTY+(main_depth-depth)-1;
        else
        best.val = INFTY-(main_depth-depth)+1;
  }

  // odwal to do TranspTable
  trans->StoreMove(hk, hl, pos->k_ruch, depth, best);

  return best;
}

CMoveInfo CEwaluator::MTDf(CNode* node,
                           COpisRuchu* orh,
                           CTranspTable* trans,
                           int depth,
                           CMoveInfo* tryFirst)
{
  CMoveInfo g;
  int beta;
  int upperbound = INFTY;
  int lowerbound = -INFTY;

  g = *tryFirst;

  do
  {
    if (g.val == lowerbound)
      beta = g.val + 1;
      else
      beta = g.val;

    g = this->AlphaBeta(node, orh, trans, depth, beta - 1, beta, tryFirst);

    if (g.val < beta)
      upperbound = g.val;
      else
      lowerbound = g.val;

  } while(lowerbound < upperbound);

  return g;
}
