// -------------------------------------
//
// -------------------------------------

#ifndef SZACHOW_H
#define SZACHOW_H

#include <windows.h>

#include "drzewa.h"
#include "moves.h"
//#include "transp.h"

enum ehbmPieces { BM_B_PION_B, BM_B_PION_C, BM_B_WIEZA_B, BM_B_WIEZA_C,
                  BM_B_SKOCZEK_B, BM_B_SKOCZEK_C, BM_B_GONIEC_B, BM_B_GONIEC_C,
                  BM_B_HETMAN_B, BM_B_HETMAN_C, BM_B_KROL_B, BM_B_KROL_C,
                  BM_C_PION_B, BM_C_PION_C, BM_C_WIEZA_B, BM_C_WIEZA_C,
                  BM_C_SKOCZEK_B, BM_C_SKOCZEK_C, BM_C_GONIEC_B, BM_C_GONIEC_C,
                  BM_C_HETMAN_B, BM_C_HETMAN_C, BM_C_KROL_B, BM_C_KROL_C,
                  BM_B_PUSTE, BM_C_PUSTE };   

const char I_BPION = 0;
const char I_CPION = 1;
const char I_BWIEZA = 2;
const char I_CWIEZA = 3;
const char I_BSKOCZEK = 4;
const char I_CSKOCZEK = 5;
const char I_BGONIEC = 6;
const char I_CGONIEC = 7;
const char I_BHETMAN = 8;
const char I_CHETMAN = 9;
const char I_BKROL = 10;
const char I_CKROL = 11;
const char I_PUSTE = 12;
const char I_ZAJETE = 13;


enum EKolor {C_BIALE, C_CZARNE, C_BRAK};

EKolor KolorBierki(char bierka);

class CTranspTable;

class EMoveInfo_BADINITIALIZATION {};

class CMoveInfo {
public:
  int xs, ys, xd, yd;
  char nacopromowac;
  int val;

  CMoveInfo() {
                val = 0; xs = 0; ys = 0;
                xd = 0; yd = 0;
                nacopromowac = I_PUSTE;
              }

  CMoveInfo(int txs, int tys, int txd, int tyd, int prom)
              {
                val = 0;
                xs = txs; ys = tys;
                xd = txd; yd = tyd;
                nacopromowac = prom;
              }

  CMoveInfo(char* src_move, char* dest_move);

  CMoveInfo& operator=(const CMoveInfo& s)
         {
           if (this == &s) return *this;
           val = s.val;
           xs = s.xs; ys = s.ys;
           xd = s.xd; yd = s.yd;
           nacopromowac = s.nacopromowac;
           return *this;
         }

  friend int operator==(const CMoveInfo& s, CMoveInfo& t)
         {
           if (
                s.xs == t.xs &&
                s.ys == t.ys &&
                s.xd == t.xd &&
                s.yd == t.yd
              )
           return 1;
           return 0;
         }

};

class CSzachownica {
public:

  char bierki[8][8];       // uklad bierek na planszy: wiersz, kolumna
  CMoveInfo pm;              // poprzedni ruch

  EKolor k_ruch;                     // na kogo przypada posuniecie
  int nr_pos;

  double value;

  bool b_roszadakrotka;
  bool b_roszadadluga;
  bool c_roszadakrotka;
  bool c_roszadadluga;
  int doremisu;

  CSzachownica();
  CSzachownica(const CSzachownica& szach);

  void UstawieniePoczatkowe();
  void PrzesunBierke(CMoveInfo move);
  void PrzeciwnaStronaGra();
  int  ZnajdzWspolrzedneKrola(bool s_ruch);
  int  ZnajdzWspolrzedneKrolaEval(EKolor kolor);
  bool CzyPoleJestPodBiciem(int x, int y, COpisRuchu* orh, bool s_ruch);
  bool CzyJestPat(COpisRuchu* orh);
  bool CzyJestSzach(COpisRuchu* orh);
  bool CzyJestMat(COpisRuchu* orh);
  MoveStatus CzyRuchPoprawny(CMoveInfo move,
                             COpisRuchu* orh,
                             bool s_ruch,
                             bool n_test);

  void Dopiski(COpisRuchu* orh);
  CMoveInfo AI(COpisRuchu* orh, CTranspTable* trans, bool s_w, bool s_b);
  void WypiszHWND(HWND hwnd);

};

#endif
