#include <stdlib.h>

#include "drzewa.h"
#include "szachow.h"

void CNode::AddChild(void* element)
{
  CNode* child = new CNode;

  child->el = element;

  child->parent = this;
  child->children = NULL;
  child->next = children;
  children = child;
}

void CNode::PushChildToHead(int nr)
{
  int i;
  CNode *tmp = children, *otoon;

  // zerowy dzieciak, no problem
  if ((nr <= 0) || (tmp == NULL)) return;

  for (i=0; i<nr-1; i++)
  {
    tmp = tmp->next;
    if (tmp->next == NULL) return;    // nie przekrocz ilosci dzieciakow
  }

  otoon = tmp->next;
  // przepisz wiazanie
  tmp->next = otoon->next;
  otoon->next = children;
  children = otoon;

}

CNode* CNode::Child(int nr)
{
  int i;
  CNode* tmp = children;

  for (i=0; i<nr; i++)
    if (tmp == NULL)
       return NULL;
       else
       tmp = tmp->next;
  return tmp;
}

int CNode::CountChildren()
{
  CNode* tmp;
  int cnt = 0;

  tmp = children;
  while (tmp!=NULL)
  {
    tmp = tmp->next;
    cnt++;
  }
  return cnt;
}

// usuwa wszystkie dzieci, wlacznie z zabiciem rozwieszonych szachownic
void CNode::RemoveChildren()
{
  CNode *tmp, *tmpn;

  tmp = this->children;
  tmpn = (this->children ? this->children->next : NULL);

  while (tmp!=NULL)
  {
    tmp->RemoveChildren();
    if (tmp->el) delete (CSzachownica*)(tmp->el);
    delete tmp;

    tmp = tmpn;
    tmpn = (tmpn ? tmpn->next : NULL);
  }

};
