﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;

namespace WebApplication1
{
    public class Startup
    {
        IConfiguration Configuration { get; set; }
        // This method gets called by the runtime. Use this method to add services to the container.
        // For more information on how to configure your application, visit https://go.microsoft.com/fwlink/?LinkID=398940
        public void ConfigureServices(IServiceCollection services)
        {
            services.AddSingleton<IConfiguration>(Configuration);
        }

        public Startup( IHostingEnvironment env )
        {
            var builder = new ConfigurationBuilder();

            builder.SetBasePath(env.ContentRootPath);
            builder.AddJsonFile(".\\Configuration\\appSettings.json", true);

            Configuration = builder.Build();
        }

        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(
            IApplicationBuilder app, 
            IHostingEnvironment env)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }

            /*
            app.Run(async (context) =>
            {
                await context.Response.WriteAsync("Hello World!");
            });
            */

            app.Use(async (context, next) =>
            {
                await context.Response.WriteAsync("hello 1");
                await next();
                await context.Response.WriteAsync("hello 1 end");
                context.Response.StatusCode = 202;
            });
            app.Use(next => 
                async context =>
                {
                    try
                    {
                        await context.Response.WriteAsync("hello 2");
                        //await next.Invoke(context);
                        var task = next.Invoke(context);
                        await task;
                        await context.Response.WriteAsync("hello 2 end");
                    }
                    catch ( Exception ex )
                    {
                        int v = 0;
                    }
                });
            //app.UseMiddleware<CustomMiddlewareWithConfiguration>();
            app.Use(async (context, next) =>
                {
                    await context.Response.WriteAsync("run");
                    await next();
                });
            /*
            app.Run(async context =>
            {
                await context.Response.WriteAsync("run");
            });
            */
        }
    }

    public class CustomMiddlewareWithConfiguration
    {
        RequestDelegate _next { get; set; }
        IConfiguration _config { get; set; }

        public CustomMiddlewareWithConfiguration(RequestDelegate next, IConfiguration config)
        {
            this._next = next;
            this._config = config;
        }

        public async Task InvokeAsync( HttpContext context )
        {
            var foo = this._config.GetValue<string>("foo");
            await context.Response.WriteAsync($"konfiguracja foo ${foo}");
            await _next(context);
        }
    }
}
