﻿using ActualWebApplication.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace ActualWebApplication.Controllers
{
    [Authorize]
    public class HomeController : Controller
    {
        [HttpGet]
        public ActionResult Index()
        {
            HomeModel model = new HomeModel();
            return View(model);
        }

        [HttpPost]
        // ochrona przed atakiem:
        //[ValidateAntiForgeryToken]
        public ActionResult Index(HomeModel model)
        {            
            if ( !string.IsNullOrEmpty(model.SensitiveData))
            {
                this.Submits.Add(model.SensitiveData);
            }
            model.Submits = this.Submits;
            return View(model);
        }

        public List<string> Submits
        {
            get
            {
                if ( this.Session["submits"] == null )
                {
                    this.Session["submits"] = new List<string>();
                }

                return this.Session["submits"] as List<string>;
            }
        }
    }
}