/**
 * WEPPO 2017
 * Przykład autentykacji za pomocą OAuth2
 * 
 * Aplikacja zadziała tylko po wcześniejszym zarejestrowaniu jej w Google i 
 * odblokowaniu dostępu do Google+ API
 * 
 * Wiecej: http://www.wiktorzychla.com/2014/11/simple-oauth2-federated-authentication.html
 * 
 * Po zarejestrowaniu aplikacji należy przepisać jej id i secret z zakładki
 * Interfejsy API i usługi / Dane logowania do pól id/secret poniżej
 */
var http = require('http');
var https = require('https');
var express = require('express');
var bodyParser = require('body-parser');
var cookieParser = require('cookie-parser');
var simpleOauthModule = require('simple-oauth2');

const oauth2 = simpleOauthModule.create({
    client: {
        id: '<tu id>',
        secret: '<tu secret>',
    },
    auth: {
        tokenHost: 'https://www.googleapis.com',
        tokenPath: '/oauth2/v4/token',
        authorizeHost: 'https://accounts.google.com',
        authorizePath: '/o/oauth2/v2/auth'
    },
});

const authorizationUri = oauth2.authorizationCode.authorizeURL({
    redirect_uri: 'http://localhost:3000/callback',
    scope: 'openid profile email'
});

var app = express();

app.use(bodyParser.urlencoded({ extended: true }));
app.use(cookieParser('sgs90890s8g90as8rg90as8g9r8a0srg8'));

app.set('view engine', 'ejs');
app.set('views', './views');

// wymaga logowania
app.get('/', authorize, (req, res) => {
    res.render('app', { user: req.user });
});

app.get('/logout', authorize, (req, res) => {
    res.cookie('user', '', { maxAge: -1 });
    res.redirect('/')
});

// strona logowania
app.get('/login', (req, res) => {
    res.render('login', { google: authorizationUri });
});

app.post('/login', (req, res) => {
    var username = req.body.txtUser;
    var pwd = req.body.txtPwd;

    if (username == pwd) {
        // wydanie ciastka
        res.cookie('user', username, { signed: true });
        // przekierowanie
        var returnUrl = req.query.returnUrl;
        res.redirect(returnUrl);
    } else {
        res.render('login', { message: "Zła nazwa logowania lub hasło", google: authorizationUri });
    }
});

app.get('/callback', (req, res) => {

    const code = req.query.code;
    const options = {
        code,
        redirect_uri: 'http://localhost:3000/callback'
    };

    // żądanie do punktu końcowego oauth2 zamieniające code na access_token
    oauth2.authorizationCode.getToken(options, (error, result) => {
        if (error) {
            return res.end(`Błąd: ${error}`);
        }
        const token = oauth2.accessToken.create(result);

        // żądanie do usługi profile API Google+ po profil użytkownika
        var opts = {
            host: 'www.googleapis.com',
            path: '/plus/v1/people/me/openIdConnect',
            headers: {
                "Authorization": `Bearer ${encodeURIComponent(token.token.access_token)}`
            }
        }
        https.get(opts, profileRes => {
            var profileJson = '';
            profileRes.on('data', data => {
                profileJson += data.toString()
            });
            profileRes.on('end', () => {
                var profile = JSON.parse(profileJson);
                if (profile.email) {
                    // zalogowanie 
                    res.cookie('user', profile.email, { signed: true });
                    res.redirect('/');
                } else {
                    // obsługa błędu
                    if (profile.error) {
                        res.end(profile.error);
                    } else {
                        res.end(`Błąd żądania do usługi profile API`);
                    }

                }
            });
        });
    });
});

// middleware autentykacji
function authorize(req, res, next) {
    if (req.signedCookies.user) {
        req.user = req.signedCookies.user;
        next();
    } else {
        res.redirect('/login?returnUrl=' + req.url);
    }
}

http.createServer(app).listen(3000);
console.log('serwer działa, nawiguj do http://localhost:3000');