﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;

namespace WpfApplication1
{
    public class MainWindowModel : INotifyPropertyChanged
    {
        public string Name
        {
            get; set;
        }
        public ICommand TheButtonClick
        {
            get
            {
                return new ButtonClickCommand( p =>
                {
                    MessageBox.Show(string.Format("{0} {1}", this.SelectedParent, this.SelectedChild));
                });
            }
        }

        public IEnumerable<string> Parents
        {
            get
            {
                return new[]
                {
                    "foo",
                    "bar",
                    "qux"
                };
            }
        }

        private string _selectedParent;

        private void RaisePropertyChanged( string propertyName )
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
        }

        public event PropertyChangedEventHandler PropertyChanged;

        public string SelectedParent
        {
            get
            {
                return _selectedParent;
            }
            set
            {
                _selectedParent = value;
                RaisePropertyChanged("Children");
            }
        }

        public IEnumerable<string> Children
        {
            get
            {
                if (string.IsNullOrEmpty(this.SelectedParent))
                    yield break;

                for (int i = 0; i < 5; i++)
                    yield return string.Format("{0} {1}", this.SelectedParent, i);
            }
        }

        public string SelectedChild
        {
            get; set;
        }
    }

    public class ButtonClickCommand : ICommand
    {
        private Action<object> _action;
        public ButtonClickCommand( Action<object> action )
        {
            this._action = action;
        }

        public event EventHandler CanExecuteChanged;

        public bool CanExecute(object parameter)
        {
            return true;
        }

        public void Execute(object parameter)
        {
            this._action(parameter);            
        }
    }
}
