﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="WebForm1.aspx.cs" Inherits="WebApplication9.WebForm1" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <script src="https://code.jquery.com/jquery-2.2.4.min.js">
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <asp:ScriptManager ID="ScriptManager1" runat="server">
            <Services>
                <asp:ServiceReference Path="~/Service1.svc" />
            </Services>
        </asp:ScriptManager>
    </div>
    </form>
    <input type="text" id="input1" value="foo bar qux" />
    <div>
        WCF udostępniony przez ScriptManager + jQuery
        <button id="button1">Service1</button>
    </div>
    <div>
        WCF z webHttpBinding + jQuery
        <button id="button2">Service2</button>
    </div>
    <div>
        WebAPI + vanilla js
        <button id="button3">Service3</button>
    </div>
    <script>
        $(function () {

            $("#button1").on('click', function () {
                var input1val = $('#input1').val();

                tempuri.org.IService1.DoWork(
                    input1val,
                    function (result) {
                        window.alert(result);
                    });
                
            });

            $('#button2').on('click', function () {

                var input1val = $('#input1').val();

                $.getJSON('/service2.svc/dowork', 's=' + input1val,
                    function (result) {
                        window.alert(result);
                    });

            });

        });

        window.addEventListener('load', function () {

            var button3 = document.getElementById('button3');
            button3.addEventListener('click', function () {

                var input1val = document.getElementById('input1').value;
                var req = new XMLHttpRequest();
                req.onreadystatechange = function () {
                    if (req.readyState == XMLHttpRequest.DONE) {
                        window.alert(req.responseText);
                    }
                };
                req.open('GET', '/api/service3?s=' + input1val, true);
                req.send();

            });

        });

    </script>
</body>
</html>
