﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.ServiceModel.Description;
using System.ServiceModel.Dispatcher;
using System.Text;
using System.Threading.Tasks;
using Interface;

namespace Service
{
    class Program
    {
        static void Main( string[] args )
        {
            using ( ServiceHost host = new ServiceHost( typeof( TheImplementation ), new Uri( "http://localhost:12345/TheService" ) ) )
            {
                var binding = new BasicHttpBinding();
                var address = new Uri( "http://localhost:12345/TheService" );

                var endpoint = host.AddServiceEndpoint( typeof( TheInterface ), binding, address );
                endpoint.EndpointBehaviors.Add( new InspectorBehavior() );

                // opcjonalnie - behavior

                // opcjonalnie - WSDL
                host.Description.Behaviors.Add( new ServiceMetadataBehavior() { HttpGetEnabled = true } );

                host.Open();

                Console.WriteLine( "Host listens" );
                Console.ReadLine();
            }
        }
    }

    /// <summary>
    /// Podstawowa infrastruktura rozszerzania
    /// </summary>
    class InspectorBehavior : IEndpointBehavior
    {
        #region IEndpointBehavior Members

        public void AddBindingParameters( ServiceEndpoint endpoint, System.ServiceModel.Channels.BindingParameterCollection bindingParameters )
        {
        }

        public void ApplyClientBehavior( ServiceEndpoint endpoint, System.ServiceModel.Dispatcher.ClientRuntime clientRuntime )
        {
        }

        public void ApplyDispatchBehavior( ServiceEndpoint endpoint, System.ServiceModel.Dispatcher.EndpointDispatcher endpointDispatcher )
        {
            endpointDispatcher.DispatchRuntime.MessageInspectors.Add( new DispatchInspector() );
        }

        public void Validate( ServiceEndpoint endpoint )
        {
        }

        #endregion
    }

    /// <summary>
    /// Przykładowe rozszerzenie - inspektor wiadomości
    /// </summary>
    class DispatchInspector : IDispatchMessageInspector
    {
        #region IDispatchMessageInspector Members

        public object AfterReceiveRequest( 
            ref System.ServiceModel.Channels.Message request, 
            IClientChannel channel, InstanceContext instanceContext )
        {
            MessageBuffer buffer = request.CreateBufferedCopy( Int32.MaxValue );
            request = buffer.CreateMessage();
            Console.WriteLine( "Received:\n{0}", buffer.CreateMessage().ToString() );
            return null;
        }

        public void BeforeSendReply( ref System.ServiceModel.Channels.Message reply, object correlationState )
        {
            MessageBuffer buffer = reply.CreateBufferedCopy( Int32.MaxValue );
            reply = buffer.CreateMessage();
            Console.WriteLine( "Sending:\n{0}", buffer.CreateMessage().ToString() );
        }

        #endregion
    }
}
