﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.ServiceModel.Description;
using System.ServiceModel.Dispatcher;
using System.Text;
using System.Threading.Tasks;
using Interface;

namespace Client
{
    class Program
    {
        static void Main( string[] args )
        {
            ChannelFactoryDemo();
            ClientBaseDemo();

            Console.ReadLine();
        }

        /// <summary>
        /// Do uzyskania proxy wykorzystany jest ChannelFactory
        /// </summary>
        private static void ChannelFactoryDemo()
        {
            var factory = new ChannelFactory<TheInterface>( new BasicHttpBinding() );

            var address = new EndpointAddress( "http://localhost:12345/TheService" );

            var client = factory.CreateChannel( address );
            Console.WriteLine( client.DoWork( "foo" ) );
            ( client as IDisposable ).Dispose();
        }

        /// <summary>
        /// Do uzyskania proxy wykorzystany jest ClientBase (tu: napisany ręcznie)
        /// 
        /// Plus: można korzystać z rozszerzeń
        /// </summary>
        private static void ClientBaseDemo()
        {
            var address = new EndpointAddress( "http://localhost:12345/TheService" );

            using ( var client = new TheInterfaceProxy( new BasicHttpBinding(), address ) )
            {
                client.Endpoint.EndpointBehaviors.Add( new InspectorBehavior() );

                Console.WriteLine( client.DoWork( "bar" ) );
            }
        }
    }

    public class TheInterfaceProxy : ClientBase<TheInterface>, TheInterface
    {
        public TheInterfaceProxy( Binding binding, EndpointAddress address ) : base( binding, address ) { }

        #region TheInterface Members

        public string DoWork( string Work )
        {
            return this.Channel.DoWork( Work );
        }

        #endregion
    }

    /// <summary>
    /// Podstawowa infrastruktura rozszerzania
    /// </summary>
    class InspectorBehavior : IEndpointBehavior
    {
        #region IEndpointBehavior Members

        public void AddBindingParameters( ServiceEndpoint endpoint, System.ServiceModel.Channels.BindingParameterCollection bindingParameters )
        {
        }

        public void ApplyClientBehavior( ServiceEndpoint endpoint, System.ServiceModel.Dispatcher.ClientRuntime clientRuntime )
        {
            clientRuntime.ClientMessageInspectors.Add( new DispatchInspector() );
        }

        public void ApplyDispatchBehavior( ServiceEndpoint endpoint, System.ServiceModel.Dispatcher.EndpointDispatcher endpointDispatcher )
        {
        }

        public void Validate( ServiceEndpoint endpoint )
        {
        }

        #endregion
    }

    /// <summary>
    /// Przykładowe rozszerzenie - inspektor wiadomości
    /// </summary>
    class DispatchInspector : IClientMessageInspector
    {
        #region IClientMessageInspector Members

        public void AfterReceiveReply( ref Message reply, object correlationState )
        {
            MessageBuffer buffer = reply.CreateBufferedCopy( Int32.MaxValue );
            reply = buffer.CreateMessage();
            Console.WriteLine( "Receiving:\n{0}", buffer.CreateMessage().ToString() );
        }

        public object BeforeSendRequest( ref Message request, IClientChannel channel )
        {
            MessageBuffer buffer = request.CreateBufferedCopy( Int32.MaxValue );
            request = buffer.CreateMessage();
            Console.WriteLine( "Sending:\n{0}", buffer.CreateMessage().ToString() );

            return null;
        }

        #endregion
    }
}
