﻿using _20150512_p1.Linq2Sql;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace _20150512_p1.Repository
{
    public class Linq2SqlParentRepository : IGenericRepository<IParent>
    {
        public Linq2SqlParentRepository( ParentChildDataContext context )
        {
            this._context = context;
        }

        ParentChildDataContext _context;

        public IParent New()
        {
            return new Parent();
        }

        public void Insert(IParent item)
        {
            if (item == null)
                throw new ArgumentNullException();
            if ( !(item is Parent))
                throw new ArgumentNullException();

            this._context.Parents.InsertOnSubmit(item as Parent);

            this._context.SubmitChanges();
        }

        public void Update(IParent item)
        {
            this._context.SubmitChanges();
        }

        public void Delete(IParent item)
        {
            this._context.Parents.DeleteOnSubmit(item as Parent);
            this._context.SubmitChanges();
        }

        public IQueryable<IParent> Query
        {
            get 
            { 
                return this._context.Parents; 
            }
        }
    }
}
