﻿using _20150512_p1.Linq2Sql;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace _20150512_p1.Repository
{
    public class Linq2SqlChildRepository : IGenericRepository<IChild>
    {
        public Linq2SqlChildRepository(ParentChildDataContext context)
        {
            this._context = context;
        }

        ParentChildDataContext _context;

        public IChild New()
        {
            return new Child();
        }

        public void Insert(IChild item)
        {
            if (item == null)
                throw new ArgumentNullException();

            this._context.Childs.InsertOnSubmit(item as Child);

            this._context.SubmitChanges();
        }

        public void Update(IChild item)
        {
            this._context.SubmitChanges();
        }

        public void Delete(IChild item)
        {
            this._context.Childs.DeleteOnSubmit(item as Child);
            this._context.SubmitChanges();
        }

        public IQueryable<IChild> Query
        {
            get
            {
                return this._context.Childs;
            }
        }
    }
}
