﻿using _20150512_p1.Linq2Sql;
using _20150512_p1.Repository;
using _20150512_p1.UoW;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace _20150512_p1
{
    class Program
    {
        static void Main(string[] args)
        {
            ComposeRoot();

            ParentService service = new ParentService();

            service.Foo();
        }

        static void ComposeRoot()
        {
            UoWFactory.SetProvider(() =>
                {
                    ParentChildDataContext context = new ParentChildDataContext();
                    Linq2SqlUoW uow = new Linq2SqlUoW(context);

                    return uow;
                });
        }
    }

    public class ParentService
    {
        private IUoW _uow;
        public ParentService()
        {
            this._uow = new UoWFactory().Create();
        }

        public void Foo()
        {
            var p = this._uow.Parents.New();
            p.ParentName = DateTime.Now.ToString();

            var children = this._uow.Childs.Query.Where(c => c.Parent.ParentName.StartsWith("k"));


            this._uow.Parents.Insert(p);
        }
    }
}
