﻿using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Collections.Generic;

/// <summary>
/// Summary description for Helpers
/// </summary>
public class Helpers
{
    public static string ToAppRelativeWithQueryString( string VirtualPath )
    {
        if ( !string.IsNullOrEmpty( VirtualPath ) )
        {
            List<string> PathWithQuery = VirtualPath.Split( '?' ).ToList();

            PathWithQuery[0] = VirtualPathUtility.ToAppRelative( PathWithQuery[0] );

            return string.Join( "?", PathWithQuery.ToArray() );
        }
        else
            return VirtualPath;
    }

    public static string CreateVirtualUrl( string RootOrientedUrl )
    {
        if ( !string.IsNullOrEmpty( RootOrientedUrl ) )
        {
            bool tilda = false;
            if ( RootOrientedUrl.StartsWith( "/" ) )
            {
                /* virtualpathutility.toapprelative nie obsługuje querystring! */
                RootOrientedUrl = ToAppRelativeWithQueryString( RootOrientedUrl );
            }
            if ( RootOrientedUrl.StartsWith( "~/" ) )
            {
                tilda = true;
                RootOrientedUrl = RootOrientedUrl.Substring( 2 );
            }

            return string.Format( "{0}/{1}/{2}",
                tilda ? "~" : string.Empty,
                HttpContext.Current.Session["INSTANCE"],
                RootOrientedUrl );
        }

        return string.Empty;
    }
}
