﻿using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Web.SessionState;

/// <summary>
/// Summary description for Global
/// </summary>
public class Global : System.Web.HttpApplication, IRequiresSessionState
{
	public Global()
	{
		//
		// TODO: Add constructor logic here
		//
	}

    void Application_Start( object sender, EventArgs e )
    {
        // Code that runs on application startup

    }

    void Application_End( object sender, EventArgs e )
    {
        //  Code that runs on application shutdown

    }

    void Application_BeginRequest( object sender, EventArgs e )
    {
        HttpApplication app = (HttpApplication)this;
        HttpContext ctx = app.Context;

        string LocalPath = Helpers.ToAppRelativeWithQueryString( ctx.Request.Url.PathAndQuery );
        string[] Segments = LocalPath.Split( '/' );

        if ( Segments.Length > 2 )
        {
            string Instance = Segments[Segments.Length - 2].Replace( "/", "" );

            /* remember curren instance */
            ctx.Items["INSTANCE"] = Instance;
            /* remember that url has been rewritten */
            ctx.Items["REWRITE"] = true;

            string NewUrl = app.Request.Url.PathAndQuery.Replace( "/" + Instance, "" );

            app.Context.RewritePath( NewUrl );
        }
    }

    void Application_AcquireRequestState( object sender, EventArgs e )
    {
        HttpApplication app = (HttpApplication)this;
        HttpContext ctx = app.Context;

        /* copy from items to session */
        if ( ctx.Items["INSTANCE"] != null )
            ctx.Session["INSTANCE"] = ctx.Items["INSTANCE"];
    }

    void Application_Error( object sender, EventArgs e )
    {
        // Code that runs when an unhandled error occurs

    }

    void Session_Start( object sender, EventArgs e )
    {
        // Code that runs when a new session is started

    }

    void Session_End( object sender, EventArgs e )
    {
        // Code that runs when a session ends. 
        // Note: The Session_End event is raised only when the sessionstate mode
        // is set to InProc in the Web.config file. If session mode is set to StateServer 
        // or SQLServer, the event is not raised.

    }

}
