using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if ( this.IsCallback() )
            return;

        if ( !this.IsPostBack )
        {
            InitializeCountries( DropDownList1 );
            InitializeCountries( DropDownList3 );
        }

        // zdarzenie client-side dla AJAX
        DropDownList3.Attributes["onchange"] = "FillCityList()";
    }

    /// <summary>
    /// W przypadku Callbacku do tej samej strony,
    /// callback mona odrni od zwykego PostBack jakkolwiek,
    /// byleby sposb odrniania by ustalony.
    /// 
    /// W tym przypadku: QueryString
    /// </summary>
    /// <returns></returns>
    protected bool IsCallback()
    {
        if ( Request.QueryString["AJAX"] != null )
        {
            string kraj = Request.QueryString["COUNTRY"];
            if ( kraj != null )
            {
                Response.Clear();
                Response.Write( Logic.GetCityListAJAX( kraj ) );
                Response.Flush();
                Response.End();

                return true;
            }
        }

        return false;
    }

    void InitializeCountries( DropDownList dropDownList )
    {
        string[] countries = { "Polska", "Niemcy", "Francja", "USA" };
        foreach ( string country in countries )
            dropDownList.Items.Add( country );
    }

    /// <summary>
    /// Ten formant DropDownList1, napenia list elementw kontrolki podrzdnej, DropDownList2,
    /// w zwyky sposb, przetwarzajc zdarzenie na serwerze
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void DropDownList1_SelectedIndexChanged( object sender, EventArgs e )
    {
		if ( DropDownList1.SelectedItem != null )
		{
			DropDownList2.Items.Clear();

			foreach ( string item in Logic.GetCityList( DropDownList1.SelectedItem.Text ) )
			{
				DropDownList2.Items.Add( item );
			}
		}
    }
    /// <summary>
    /// Poniewa formant DropDownList2 zosta napeniony w zwyky sposb,
    /// to w zwyky sposb mona z niego odczyta warto
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Button1_Click( object sender, EventArgs e )
    {
        if ( DropDownList2.SelectedItem != null )
            Response.Write( DropDownList2.SelectedValue );
    }
    /// <summary>
    /// Poniewa formant DropDownList4 zosta napeniony poza zwykym potokiem przetwarzania,
    /// dostp do wybranego elementu nie jest moliwy w standardowy sposb
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Button2_Click( object sender, EventArgs e )
    {
        // uwaga! tak nie wolno!			
        //if ( DropDownList4.SelectedItem != null )
        //	Response.Write( DropDownList4.SelectedValue );

        string[] values = Request.Form.GetValues( DropDownList4.ClientID );
        if ( values.Length == 1 )
            Response.Write( values[0] );
    }
}
