using System;
using System.Security;
using System.Security.Permissions;

namespace PermissionDemand
{
	class EntryPoint
	{
		static void Main(string[] args)
		{
			String f = @"c:\System Volume Information";
			FileIOPermission p = 
				new FileIOPermission(
				FileIOPermissionAccess.Write, f);

			try
			{
				p.Demand();
				p.Deny();
				p.Demand();
				CheckDeny(p);
				p.Assert();
				CheckDeny(p);
			}
			catch ( SecurityException )
			{
				Console.WriteLine("Demand failed");
			}
		}

		static void CheckDeny(FileIOPermission p)
		{
			try
			{
				p.Demand();
			}
			catch ( SecurityException )
			{
				Console.WriteLine("Demand failed");
			}
		}
	}
}
