using System;
using System.Collections.Generic;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class ScriptingCallbacks : System.Web.UI.Page, ICallbackEventHandler
{
    SCHandler handler = new SCHandler();

    protected override void Render( HtmlTextWriter writer )
    {
        base.Render( writer );
        this.ClientScript.RegisterForEventValidation( DropDownList2.ClientID );
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        // binding
        if ( !this.IsPostBack )
        {
            BindCountries();
        }

        // callback
        string scriptref = this.ClientScript.GetCallbackEventReference( this, "document.all['DropDownList1'].value", "DropDown1Callback", "", true );
        DropDownList1.Attributes.Add( "onchange", scriptref );

        // custom callback handler
        this.AddParsedSubObject( handler );
        string customscriptref = this.ClientScript.GetCallbackEventReference(
            handler,
            "document.all['DropDownList3'].value",
            "CustomDropDown3Callback", "", true );
        this.DropDownList3.Attributes.Add( "onchange", customscriptref );
    }

    void BindCountries()
    {
        DropDownList1.DataSource = Logic.GetCountries();
        DropDownList1.DataBind();
    }

    #region ICallbackEventHandler Members
    string argument;
    public string GetCallbackResult()
    {
        return Logic.GetCitiesCallback( argument );
    }

    public void RaiseCallbackEvent( string eventArgument )
    {
        this.argument = eventArgument;
    }
    #endregion
    protected void Button1_Click( object sender, EventArgs e )
    {
        Response.Write( Request.Form.GetValues( DropDownList2.ClientID )[0] );
    }
}
