using System;
using System.Collections.Generic; 
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public class Tree
{
    public Tree left;
    public Tree right;
    public int value;

    public Tree( Tree left, Tree right, int value )
    {
        this.left = left;
        this.right = right;
        this.value = value;
    }

    public IEnumerator<int> GetEnumerator()
    {
        if ( left != null )
        {
            IEnumerator<int> e = left.GetEnumerator();
            while ( e.MoveNext() )
                yield return e.Current;
        }

        yield return value;

        if ( right != null )
        {
            IEnumerator<int> e = right.GetEnumerator();
            while ( e.MoveNext() )
                yield return e.Current;
        }
    }
}
