using System;
using System.Security;
using System.Security.Principal;
using System.Web;
using System.Web.Security;

namespace WebApplication7
{
	public class MyPrincipal : IPrincipal
	{
		private IIdentity m_identity;
		private string[] m_roles;

		public MyPrincipal( IIdentity identity, string[] roles )
		{
			this.m_identity = identity;
			this.m_roles    = roles;
		}

		#region IPrincipal Members
		public IIdentity Identity
		{
			get
			{
				return m_identity;
			}
		}

		public bool IsInRole(string role)
		{
			return Array.IndexOf( m_roles, role ) >= 0;
		}

		#endregion
	}
}
