using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace WebApplication6
{
	public class WebForm1 : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.DataGrid DataGrid2;
		protected System.Web.UI.WebControls.DataGrid DataGrid1;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			if ( !this.IsPostBack )
			{
				BindUczelnie();
				BindStudenci();
			}
		}

		void BindUczelnie()
		{
			DataGrid1.DataSource = SQLLayer.Uczelnie;
			DataGrid1.DataBind();
		}
		void BindStudenci()
		{
			DataGrid2.DataSource = SQLLayer.Studenci( Uczniowie_SortExpr );
			DataGrid2.DataBind();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.DataGrid2.ItemCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.DataGrid2_ItemCommand);
			this.DataGrid2.PageIndexChanged += new System.Web.UI.WebControls.DataGridPageChangedEventHandler(this.DataGrid2_PageIndexChanged);
			this.DataGrid2.CancelCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.DataGrid2_CancelCommand);
			this.DataGrid2.EditCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.DataGrid2_EditCommand);
			this.DataGrid2.SortCommand += new System.Web.UI.WebControls.DataGridSortCommandEventHandler(this.DataGrid2_SortCommand);
			this.DataGrid2.UpdateCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.DataGrid2_UpdateCommand);
			this.DataGrid2.ItemDataBound += new System.Web.UI.WebControls.DataGridItemEventHandler(this.DataGrid2_ItemDataBound);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void DataGrid2_PageIndexChanged(object source, System.Web.UI.WebControls.DataGridPageChangedEventArgs e)
		{
			DataGrid2.CurrentPageIndex = e.NewPageIndex;
			BindStudenci();
		}

		public int Uczniowie_SortExpr
		{
			get
			{
				if ( Session["US"] == null )
					return 0;
				else
					return (int)Session["US"];
			}
			set
			{
				Session["US"] = value;
			}
		}
		private void DataGrid2_SortCommand(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
		{
			Uczniowie_SortExpr = int.Parse(e.SortExpression);
			BindStudenci();
		}

		private void DataGrid2_CancelCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			DataGrid2.EditItemIndex = -1;
			BindStudenci();
		}

		private void DataGrid2_EditCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			DataGrid2.EditItemIndex = e.Item.ItemIndex;
			BindStudenci();
		}

		private void DataGrid2_UpdateCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			int ID_STUDENT  = (int)DataGrid2.DataKeys[e.Item.ItemIndex];
			int ID_UCZElNIA = int.Parse(((DropDownList)e.Item.FindControl( "cbUczelnia" )).SelectedValue);

			// itd., update

			DataGrid2.EditItemIndex = -1;
			BindStudenci();
		}

		private void DataGrid2_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
		{
			if ( e.Item.ItemType == ListItemType.Item ||
				e.Item.ItemType == ListItemType.AlternatingItem )
			{
				Button b = e.Item.Cells[e.Item.Cells.Count-1].Controls[0] as Button;
				b.Attributes["onclick"] = "return window.confirm('Czy na pewno usun element?');";
			}
		}

		private void DataGrid2_ItemCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			if ( e.CommandName == "DEL" )
			{
				// usuwam element
			}
		}
	}
}
