using System;
using System.ComponentModel;
using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

namespace Vulcan.Uczniowie.Controls
{
	public class ToolTipComponent : System.ComponentModel.Component
	{
		#region Component
		private System.ComponentModel.Container components = null;

		public ToolTipComponent(System.ComponentModel.IContainer container)
		{
			container.Add(this);
			InitializeComponent();
		}

		public ToolTipComponent()
		{
			InitializeComponent();
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
					components.Dispose();

				RemoveAll();
			}
			base.Dispose( disposing );
		}


		#region Component Designer generated code
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
		}
		#endregion
		#endregion

		#region ToolTip

		Hashtable hToolTips = new Hashtable();

		public void CreateToolTip( 
			Control control,
			Win32.ToolTipStyle style
			)
		{
			CreateToolTip( control, style, null, false );
		}

		public void CreateToolTip( 
			Control control,
			Win32.ToolTipStyle style,
			string caption
			)
		{
			CreateToolTip( control, style, caption, false );
		}

		public void CreateToolTip( 
			Control control,
			Win32.ToolTipStyle style,
			bool popUpOnDemand
			)
		{
			CreateToolTip( control, style, null, popUpOnDemand );
		}

		public void CreateToolTip( 
			Control control, 
			Win32.ToolTipStyle style,
			string caption,
			bool popUpOnDemand
			)
		{
			if ( !hToolTips.ContainsKey( control.Handle ) )
			{
				ToolTip tip = new ToolTip();

				tip.CreateToolTip( control, style, popUpOnDemand );

				hToolTips.Add( control.Handle, tip );

				SetToolTipProperties( control, caption );
			}
		}

		#region ToolTip properties
		public void SetToolTipProperties( 
			Control control,
			string caption )
		{
			SetToolTipProperties( 
				control, caption,
				Win32.ToolTipIconType.TT_NOICON,
				null, null, Color.Empty, Color.Empty, 0, 0, 0, false );
		}

		public void SetToolTipProperties( 
			Control control,
			string caption,
			Win32.ToolTipIconType iconType,
			string title
			)
		{
			SetToolTipProperties( 
				control, caption,
				iconType, title,
				null, Color.Empty, Color.Empty, 0, 0, 0, false );
		}

		public void SetToolTipProperties( 
			Control control,
			string caption,
			Win32.ToolTipIconType iconType,
			string title,
			int delayTime,
			int visibleTime )
		{
			SetToolTipProperties( control, caption, iconType, title,
				null, Color.Empty, Color.Empty, delayTime, visibleTime, 0, false );
		}

		public void SetToolTipProperties( 
			Control control,
			string caption,
			Win32.ToolTipIconType iconType,
			string title,
			Font font,
			Color foreColor,
			Color backColor,
			int delayTime,
			int visibleTime,
			int maxTipWidth,
			bool centered )
		{
			if ( hToolTips.ContainsKey( control.Handle ) )
			{				
				ToolTip tip = (ToolTip)hToolTips[control.Handle];

				if ( caption != null ) tip.ToolTipText = caption;
				if ( title != null ) tip.Title = title;

				if ( foreColor != Color.Empty ) tip.ForeColor = ColorTranslator.ToOle( foreColor );
				if ( backColor != Color.Empty ) tip.BackColor = ColorTranslator.ToOle( backColor );
				if ( font != null ) tip.Font = font;
				
				if ( delayTime > 0 )   tip.DelayTime = delayTime;
				if ( visibleTime > 0 ) tip.VisibleTime = visibleTime;
				if ( maxTipWidth > 0 ) tip.MaxTipWidth = maxTipWidth;

				tip.Centered = centered;
				tip.Icon     = iconType;
			}
		}
		#endregion

		public void HideToolTip( Control control )
		{
			if ( hToolTips.ContainsKey( control.Handle ) )
				((ToolTip)hToolTips[control.Handle]).Hide();
		}

		public void ShowToolTip( Control control )
		{
			if ( hToolTips.ContainsKey( control.Handle ) )
				((ToolTip)hToolTips[control.Handle]).Show( control.Width/2, control.Height/2 );
		}

		public void ShowToolTip( Control control, int X, int Y )
		{
			if ( hToolTips.ContainsKey( control.Handle ) )
				((ToolTip)hToolTips[control.Handle]).Show( X, Y );
		}

		public string GetToolTip( Control control )
		{
			if ( hToolTips.ContainsKey( control.Handle ) )
			{
				ToolTip tip = (ToolTip)hToolTips[control.Handle];

				return tip.ToolTipText;
			}
			else
				return null;
		}

		public void RemoveToolTip( Control control )
		{
			if ( hToolTips.ContainsKey( control.Handle ) )
			{
				((ToolTip)hToolTips[control.Handle]).Dispose();				
				hToolTips.Remove( control.Handle );
			}
		}

		public void RemoveAll()
		{
			foreach ( ToolTip tip in hToolTips.Values )
				tip.Dispose();

			hToolTips.Clear();
		}

		#endregion
	}
}
