using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.Windows.Forms;
using System.Runtime.InteropServices; 

namespace FraktalJulii
{
  public class CFrmJulia : System.Windows.Forms.Form
  {
    private const int PSiz = 128;
    
    private double angle = 0.0, angle2 = 0.0;
    private int    cx, cy;

    private Bitmap picFracSource;
    private System.Windows.Forms.PictureBox picFrac;

    public CFrmJulia()
    {
      this.SetStyle(ControlStyles.DoubleBuffer, true);
      this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);

      picFracSource = new Bitmap( PSiz, PSiz, PixelFormat.Format24bppRgb );

      this.picFrac = new System.Windows.Forms.PictureBox();
      this.picFrac.Dock = DockStyle.Fill;
      this.picFrac.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;

      this.ClientSize = new System.Drawing.Size(256, 256);
      this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;

      this.Controls.Add( this.picFrac );
    }

    void JuliaPaint()
    {
      angle += 0.023; angle2+= 0.027;
      cx = (int)( 800.0 * Math.Sin( angle+1.0 ) ); 
      cy = (int)( 800.0 * Math.Cos( angle2 ) );

      Rectangle bounds = 
        new Rectangle( new Point(0, 0), 
        new Size( picFracSource.Width, picFracSource.Height ) ); 
      BitmapData bData = 
        picFracSource.LockBits( bounds, ImageLockMode.ReadWrite, 
                                PixelFormat.Format24bppRgb );

      byte[] picData = new byte[PSiz * PSiz * 3];
      int iDex = 0;

      int iterNo, i, j;
      int x, y, xn, yn, x2, y2;
      for (i=0; i<PSiz; i++ )
        for (j=0; j<PSiz; j++ )
        {
          iterNo = 0;
          
          x  = (i<<5)-2048; 
          y  = (j<<5)-2048;
          x2 = x*x;  
          y2 = y*y;
          while ( 
                  ( iterNo++ < 32 ) && 
                  ( Math.Abs(x2+y2) < 4000000 ) 
                )
          {
            x2 = x*x; y2 = y*y;
            xn = ((x2-y2)>>10) + cx;
            yn = ((x*y)>>9)    + cy;
            x  = xn; y  = yn;
          }

          picData[iDex++] = Convert.ToByte(255-iterNo);
          picData[iDex++] = Convert.ToByte(5*iterNo);
          picData[iDex++] = Convert.ToByte(5*iterNo);
        }

      Marshal.Copy ( picData, 0, bData.Scan0, PSiz * PSiz * 3 ); 
      picFracSource.UnlockBits( bData );

      this.picFrac.Image = picFracSource; 
      this.picFrac.Invalidate();
    }

    public static void Main()
    {
      CFrmJulia frm = new CFrmJulia(); 
      frm.Show();
  
      DateTime start = DateTime.Now;
      int      frame = 0;
      while ( frm.Created )
      {
        frm.JuliaPaint();
        Application.DoEvents();

        frm.Text = String.Format( "Fraktal Julii, FPS: {0:N}", 
                   frame/((TimeSpan)(DateTime.Now-start)).TotalSeconds );      
        frame++;
      } 
    }
  }
}
