/* Wiktor Zychla, 2003 */
// prosty modu serwera
// uycie: server.exe
using System;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Threading;

namespace TcpSever
{
  public class CClientThread
  {
    const  string serverMsg = "Tu serwer. Odpowiadam.";
    Socket clientSocket;

    public CClientThread( Socket clientSocket )
    {
      this.clientSocket = clientSocket;
    }

    public void ClientThreadFunc()
    {
      NetworkStream nS = new NetworkStream( clientSocket );
      StreamReader  sR = new StreamReader( nS );
      StreamWriter  sW = new StreamWriter( nS );

      while( true )
      {
        // odbierz wiadomo
        string clientMessage = sR.ReadLine();
        if ( clientMessage != null )
          Console.WriteLine( "Otrzymano wiadomo: {0}", clientMessage );
        else
          break;

        // odelij odpowied
        sW.WriteLine( serverMsg );
        sW.Flush();
      }

      sR.Close();
      sW.Close();
    }
  }

  public class CServer
  {
    public const int DEFAULT_PORT   = 5000;
 
    public static void Main()
    {     
      TcpListener tcpListener = new TcpListener( DEFAULT_PORT );
      tcpListener.Start() ;
	 
      Console.WriteLine( "Serwer nasuchuje." );
      Console.WriteLine( "Adres: {0}, port: {1}", Dns.GetHostName(), DEFAULT_PORT );

      while ( true )
      {
        Thread.Sleep(1);
        if ( tcpListener.Pending() )
        {
          Socket socketForClient = tcpListener.AcceptSocket();
          string clientName = 
              String.Format( "{0} [{1}]",
                Dns.GetHostByAddress( ((IPEndPoint)socketForClient.RemoteEndPoint).Address ).HostName,
                ((IPEndPoint)socketForClient.RemoteEndPoint).Address.ToString()
				            );
          Console.WriteLine( "Zaakceptowano poczenie: serwer {0}", clientName );

          CClientThread ct = new CClientThread( socketForClient );
          Thread         t = new Thread( new ThreadStart( ct.ClientThreadFunc ) );
          t.Start();
        }
      }
    }
  }
}
