/*
 *
 * GDI
 *
 */
#include <windows.h>
#include <string.h>

/* Deklaracja wyprzedzajca: funkcja obsugi okna */
LRESULT CALLBACK WindowProcedure(HWND, UINT, WPARAM, LPARAM);
/* Nazwa klasy okna */
char szClassName[] = "PRZYKLAD";

int WINAPI WinMain(HINSTANCE hThisInstance, HINSTANCE hPrevInstance, 
                   LPSTR lpszArgument, int nFunsterStil)
{
    HWND hwnd;               /* Uchwyt okna */
    MSG messages;            /* Komunikaty okna */
    WNDCLASSEX wincl;        /* Struktura klasy okna */

    /* Klasa okna */
    wincl.hInstance     = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc   = WindowProcedure;    // wskanik na funkcj obsugi okna  
    wincl.style         = CS_DBLCLKS;                 
    wincl.cbSize        = sizeof(WNDCLASSEX);

    /* Domylna ikona i wskanik myszy */
    wincl.hIcon   = LoadIcon(NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor(NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL; 
    wincl.cbClsExtra = 0;   
    wincl.cbWndExtra = 0;   
    /* Jasnoszare to */
    wincl.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);

    /* Rejestruj klas okna */
    if(!RegisterClassEx(&wincl)) return 0;

    /* Twrz okno */
    hwnd = CreateWindowEx(
           0,                   
           szClassName,         
           "PRZYKLAD",       
           WS_OVERLAPPEDWINDOW, 
           CW_USEDEFAULT,       
           CW_USEDEFAULT,       
           512,                 
           512,                 
           HWND_DESKTOP,        
           NULL,                
           hThisInstance,       
           NULL                 
           );

    ShowWindow(hwnd, nFunsterStil);
    /* Ptla obsugi komunikatw */
    while(GetMessage(&messages, NULL, 0, 0))
    {
           /* Tumacz kody rozszerzone */
           TranslateMessage(&messages);
           /* Obsu komunikat */
           DispatchMessage(&messages);
    }

    /* Zwr parametr podany w PostQuitMessage( ) */
    return messages.wParam;
}

int xSize, ySize;

/* T funkcj woa DispatchMessage( ) */
LRESULT CALLBACK WindowProcedure(HWND hwnd, UINT message, 
                                 WPARAM wParam, LPARAM lParam)
{
    char sText[] = "Przykad 1, witam";
    HDC         hdc ;
    int         i ;
    PAINTSTRUCT ps ;
    RECT r;

    HPEN   hPen;
    HBRUSH hBrush;
    
    switch (message)                  
    {
           case WM_DESTROY:
              PostQuitMessage(0);        
              break;
           case WM_SIZE:
              xSize = LOWORD(lParam); 
              ySize = HIWORD(lParam); 
              
              GetClientRect( hwnd, &r );
              InvalidateRect( hwnd, &r, 1 );
              
              break;   
           case WM_PAINT:
              hdc = BeginPaint (hwnd, &ps) ;
                      
              // linie             
              hPen = CreatePen (PS_SOLID, 3, RGB (255, 0, 0)) ;
              SelectObject( hdc, hPen );              
              for ( i=0; i<xSize; i+=xSize/40 )               
              {
                 MoveToEx( hdc, xSize/2, 0, NULL );
                 LineTo( hdc, i, ySize );
              }   
              DeleteObject( hPen );
          
              // ksztaty
              SetBkColor( hdc, RGB(0, 255, 0) );
              hBrush = CreateHatchBrush (HS_CROSS, RGB (0, 0, 255)) ;
              SelectObject( hdc, hBrush );
              r.left   = 10;
              r.top    = 10;
              r.right  = 50;
              r.bottom = 50;
              FillRect( hdc, &r, hBrush );              
              DeleteObject( hBrush );

              // tekst
              if ( xSize > 0 && ySize > 0 )
              {
                 SetTextAlign( hdc, TA_CENTER | VTA_CENTER );
                 SetBkMode( hdc, TRANSPARENT );
                 TextOut( hdc, xSize / 2, 20, sText, strlen( sText ) );
              }
          
              EndPaint(hwnd, &ps);
              break;   
              
           default:                   
              return DefWindowProc(hwnd, message, wParam, lParam);
    }
    return 0;
}
