﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Security.Cryptography;
using System.IO;

namespace FileEncryptionWithPasswordRecovery
{
    public class EncryptionHelper
    {
        #region RSA - signature
        private RSACryptoServiceProvider rsa;

        /// <summary>
        /// Konstruktor statyczny
        /// </summary>
        public EncryptionHelper()  
        {	
            rsa = new RSACryptoServiceProvider( 2048 );

            StreamReader reader = new StreamReader( typeof( EncryptionHelper ).Assembly.GetManifestResourceStream( @"FileEncryptionWithPasswordRecovery.publickey.xml" ) );

            string publicOnlyKeyXML = reader.ReadToEnd();
            rsa.FromXmlString( publicOnlyKeyXML );
            reader.Close();	
        }

        /// <summary>
        /// Use to generate fresh pair of private/public keys
        /// </summary>
        private void AssignNewKey()
        {
            //provide public and private RSA params	
            StreamWriter writer = new StreamWriter( @"privatekey.xml" );
            string publicPrivateKeyXML = rsa.ToXmlString( true );
            writer.Write( publicPrivateKeyXML );
            writer.Close();

            //provide public only RSA params	
            writer = new StreamWriter( @"publickey.xml" );
            string publicOnlyKeyXML = rsa.ToXmlString( false );
            writer.Write( publicOnlyKeyXML );
            writer.Close();
        }  

        public string RSAEncrypt(string data2Encrypt)  
        {	            
            //read plaintext, encrypt it to ciphertext	
            byte[] plainbytes  = System.Text.Encoding.UTF8.GetBytes(data2Encrypt);	
            byte[] cipherbytes = rsa.Encrypt( plainbytes, false );	

            return Convert.ToBase64String(cipherbytes);  
        }                  
        #endregion

        #region SHA512
        public string ComputePasswordHash( string PlainPassword )
        {
            SHA512 sha = System.Security.Cryptography.SHA512.Create();

            return Convert.ToBase64String( sha.ComputeHash( Encoding.UTF8.GetBytes( PlainPassword ) ) );
        }
        #endregion

        #region DES - file content
        public string DESEncrypt( string Data, string Password )
        {
            byte[] data_byte;

            byte[] key;
            int _KeyByteLength = 32;

            Password = Password.PadRight( _KeyByteLength, ' ' ).Substring( 0, _KeyByteLength );

            key = new byte[_KeyByteLength];

            for ( int i = 0; i < _KeyByteLength; i++ )
                key[i] = Convert.ToByte( Password[i] );

            RijndaelManaged Algorithm = new RijndaelManaged();
            Algorithm.BlockSize = _KeyByteLength * 8;
            Algorithm.KeySize   = _KeyByteLength * 8;

            MemoryStream memStream = new MemoryStream();

            ICryptoTransform Encryptor = Algorithm.CreateEncryptor( key, key );
            CryptoStream crStream  = new CryptoStream( memStream, Encryptor, CryptoStreamMode.Write );

            StreamWriter strWriter = new StreamWriter( crStream );

            strWriter.Write( Data );
            strWriter.Flush();
            crStream.FlushFinalBlock();

            data_byte = new byte[memStream.Length];

            memStream.Position = 0;
            memStream.Read( data_byte, 0, (int)data_byte.Length );

            return Convert.ToBase64String( data_byte );
        }

        public string DESDecrypt( string Data, string Password )
        {
            byte[] data = Convert.FromBase64String( Data );

            byte[] key;
            int _KeyByteLength = 32;

            Password = Password.PadRight( _KeyByteLength, ' ' ).Substring( 0, _KeyByteLength );

            key = new byte[_KeyByteLength];

            for ( int i = 0; i < _KeyByteLength; i++ )
                key[i] = Convert.ToByte( Password[i] );

            RijndaelManaged Algorithm = new RijndaelManaged();
            Algorithm.BlockSize = _KeyByteLength * 8;
            Algorithm.KeySize = _KeyByteLength * 8;

            MemoryStream memStream = new MemoryStream( data );
            ICryptoTransform Decryptor = Algorithm.CreateDecryptor( key, key );
            memStream.Position = 0;

            CryptoStream crStream  = new CryptoStream( memStream, Decryptor, CryptoStreamMode.Read );
            StreamReader strReader = new StreamReader( crStream );

            return strReader.ReadToEnd();
        }
        #endregion
    }
}
