﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace FileEncryptionWithPasswordRecovery
{
    public partial class FrmPassword : Form
    {
        enum    Mode { AskForNewPassword, AskForExistingPassword };
        private Mode PasswordMode;

        public string EMail { get; set; }
        public string Password { get; private set; }
        public string EmailPasswordHash { get; private set; }

        public string UnlockCode { get; private set; }

        private string FileName { get; set; }

        private FrmPassword() 
        {
            InitializeComponent();
        }

        public FrmPassword( string KnownEmail )
        {
            InitializeComponent();

            this.PasswordMode = Mode.AskForNewPassword;

            this.EMail = KnownEmail;

            this.txtEMail.Text  = KnownEmail;
            this.groupBox1.Text = "Enter new password";
            this.lnkPasswordLost.Enabled = false;
        }

        public FrmPassword( string FileName, string KnownEmail, string EmailPasswordHash )
        {
            InitializeComponent();

            this.PasswordMode = Mode.AskForExistingPassword;
            this.groupBox1.Text = "Login using your password";

            this.FileName  = FileName;
            this.EMail     = KnownEmail;
            this.EmailPasswordHash = EmailPasswordHash;

            /* set components */
            this.txtEMail.Text = KnownEmail;
            this.txtEMail.Enabled = false;
            this.txtPwdRepeat.Enabled = false;
        }

        private void button1_Click( object sender, EventArgs e )
        {
            if ( string.IsNullOrEmpty( this.txtPwd.Text ) )
                return;

            if ( this.PasswordMode == Mode.AskForNewPassword &&
                 this.txtPwd.Text != this.txtPwdRepeat.Text )                   
                return;

            this.EMail    = txtEMail.Text;
            this.Password = txtPwd.Text;

            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        private void linkLabel1_LinkClicked( object sender, LinkLabelLinkClickedEventArgs e )
        {
            FrmPasswordLost pl = new FrmPasswordLost( FileName, EMail, EmailPasswordHash );

            if ( pl.ShowDialog() == DialogResult.OK )
            {
                this.EMail      = txtEMail.Text;
                this.Password   = ApplicationDocument.DUMMYPASSWORD;
                this.UnlockCode = pl.UnlockCode;

                this.DialogResult = DialogResult.OK;
                this.Close();
            }
        }
    }
}
