﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace FileEncryptionWithPasswordRecovery
{
    public partial class FrmDocument : Form
    {
        ApplicationDocument document;

        private void FrmDocument_Load( object sender, EventArgs e )
        {
            txtDocumentContent.Focus();
        }

        public FrmDocument()
        {
            InitializeComponent();

            document  = new ApplicationDocument();
            this.Text = document.FileName;
        }

        public FrmDocument( string FileName )
        {
            InitializeComponent();

            document = new ApplicationDocument( FileName, new AskForExistingPasswordDelegate( AskForExistingPasswordFunc ) );

            this.Text                    = document.FileName + (document.IsEncrypted ? " (password protected)" : string.Empty);
            this.txtDocumentContent.Text = document.DocumentData;

            if ( document.IsEncrypted )
            {
                /* disallow saving with password, allow password to be changed */
                this.button2.Enabled = false;
                this.button3.Enabled = true;
            }
        }

        private string AskForExistingPasswordFunc( string FileName, string Email, string EmailPasswordHash, out string UnlockCode )
        {
            UnlockCode = null;

            /* ask for password in existing document */
            FrmPassword p = new FrmPassword( FileName, Email, EmailPasswordHash );

            if ( p.ShowDialog() == DialogResult.OK )
            {
                UnlockCode = p.UnlockCode;

                return p.Password;
            }
            else
                return null;
        }

        private void button1_Click( object sender, EventArgs e )
        {
            if ( document.Password != ApplicationDocument.DUMMYPASSWORD )
            {
                document.DocumentData = txtDocumentContent.Text;

                document.Save(
                    /* ask for filename delegate */
                    () =>
                    {
                        SaveFileDialog sf = new SaveFileDialog();
                        sf.Filter = "Application Data Files (*.adfile)|*.adfile|All Files (*.*)|*.*";
                        sf.CheckPathExists = true;
                        sf.OverwritePrompt = true;

                        if ( sf.ShowDialog() == DialogResult.OK )
                            return sf.FileName;
                        else
                            return null;
                    }
                );

                this.Text = document.FileName;
            }
            else
            {
                MessageBox.Show( "The data access has been unlocked with an unlock code.\r\n\r\nUse [Change password and save] to save the document" );
            }
        }

        private void button2_Click( object sender, EventArgs e )
        {
            document.DocumentData = txtDocumentContent.Text;

            if (
                document.SaveWithPassword(
                /* ask for filename delegate */
                () =>
                {
                    SaveFileDialog sf = new SaveFileDialog();
                    sf.Filter = "Application Data Files (*.adfile)|*.adfile|All Files (*.*)|*.*";
                    sf.CheckPathExists = true;
                    sf.OverwritePrompt = true;

                    if ( sf.ShowDialog() == DialogResult.OK )
                        return sf.FileName;
                    else
                        return null;
                },
                /* ask for new password delegate */
                ( out string UserEmail ) =>
                {
                    UserEmail = string.Empty;

                    FrmPassword p = new FrmPassword( string.Empty );

                    if ( p.ShowDialog() == DialogResult.OK )
                    {
                        UserEmail = p.EMail;
                        return p.Password;
                    }
                    else
                        return null;
                }
                )
            )
            {
                /* document has been succesfully saved with password */
                document.IsEncrypted = true;
                
                button2.Enabled = false;
                button3.Enabled = true;
                
                this.Text = document.FileName;
            }
        }

        private void button3_Click( object sender, EventArgs e )
        {
            FrmPassword p = new FrmPassword( document.UserEmail );

            if ( p.ShowDialog() == DialogResult.OK )
            {
                /* change email & password */
                document.UserEmail = p.EMail;
                document.Password = p.Password;

                /* save document using known filename */
                document.Save( () => document.FileName );
            }
        }
    }
}
