﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Security.Cryptography;

namespace FileEncryptionWithPasswordRecovery
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void exitToolStripMenuItem_Click( object sender, EventArgs e )
        {
            Close();
        }

        private void newToolStripMenuItem_Click( object sender, EventArgs e )
        {
            FrmDocument f = new FrmDocument();
            f.MdiParent = this;

            f.Show();
        }

        private void openToolStripMenuItem_Click( object sender, EventArgs e )
        {
            OpenFileDialog of = new OpenFileDialog();
            of.CheckFileExists = true;
            of.Filter = "Application Data Files (*.adfile)|*.adfile|All Files (*.*)|*.*";

            if ( of.ShowDialog() == DialogResult.OK )
            {
                try
                {
                    FrmDocument f = new FrmDocument( of.FileName );
                    f.MdiParent = this;

                    f.Show();
                }
                catch ( CryptographicException ex )
                {
                    MessageBox.Show( "Invalid password!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error );
                }
                catch ( Exception ex )
                {
                    MessageBox.Show( "Error opening document: \r\n\r\n" + ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error );
                }
            }
        }
    }
}
