﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Xml.Linq;

namespace DecryptionService
{
    [WebService( Namespace = "http://tempuri.org/" )]
    [WebServiceBinding( ConformsTo = WsiProfiles.BasicProfile1_1 )]
    [ToolboxItem( false )]
    public class DecryptionService : System.Web.Services.WebService
    {
        /// <summary>
        /// The service is provided by the application provider. 
        /// The servier is used to recover application's data files when a user losts his/her password.
        /// The email provided in the data file is used to AUTHORIZE request for password recovery.
        /// </summary>
        /// <param name="UserEmail"></param>
        /// <param name="EncryptedEmailAndHash"></param>
        [WebMethod]
        public void DecryptAndSendHashOfThePassword( string FileName, string UserEmail, string EncryptedEmailAndHash )
        {
            try
            {
                DecryptionHelper decryptor = new DecryptionHelper();

                string DecryptedData = decryptor.DecryptData( EncryptedEmailAndHash );

                /* split decrypted data using -|- as separator and take 
                 * the first item as email and last item as hash
                 */
                var DecryptedEMailAndHash = 
                new
                {
                    DecryptedEMail = DecryptedData.Split( new string[] { "-|-" }, StringSplitOptions.RemoveEmptyEntries ).First(),
                    DecryptedHash  = DecryptedData.Split( new string[] { "-|-" }, StringSplitOptions.RemoveEmptyEntries ).Last()
                };

                if ( UserEmail == DecryptedEMailAndHash.DecryptedEMail )
                {
                    /* useremail stored in document's email section matches
                     * the useremail RSAed into the signature
                     */

                    string MailContent = 
                    "this is the automated response to a request for an unlock code for file " + FileName + "\r\n\r\n" +
                        "the unlock code is \r\n\r\n" + 
                         DecryptedEMailAndHash.DecryptedHash +
                        "\r\n\r\nplease use the decrypt code to unlock access to your data in the application";

                    Mail.Send( FileName, UserEmail, MailContent );
                }
                else
                {
                    /* useremail stored in document's email section DOES NOT MATCH
                     * the useremail RSAed into the signature
                     */

                    string MailContent = 
                        "this is the automated response to a request for an unlock code for file " + FileName + "\r\n\r\n" +
                        "the document has been saved with another email and the unlock code cannot be sent";

                    Mail.Send( FileName, UserEmail, MailContent );
                }
            }
            catch ( Exception ex )
            {
                string MailContent = 
                        "this is the automated response to a request for an unlock code for file " + FileName + "\r\n\r\n" +
                        "sorry but the request cannot be processed because it's invalid.";

                Mail.Send( FileName, UserEmail, MailContent );
            }
        }
    }
}
