﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Security.Cryptography;
using System.IO;

namespace DecryptionService
{
    public class DecryptionHelper
    {
        #region RSA - signature
        private RSACryptoServiceProvider rsa;

        /// <summary>
        /// Konstruktor statyczny
        /// </summary>
        public DecryptionHelper()
        {
            rsa = new RSACryptoServiceProvider( 2048 );

            StreamReader reader = new StreamReader( typeof( DecryptionHelper ).Assembly.GetManifestResourceStream( @"DecryptionService.privatekey.xml" ) );
            string publicPrivateKeyXML = reader.ReadToEnd();
            rsa.FromXmlString( publicPrivateKeyXML );
            reader.Close();            
        }

        public string DecryptData( string data2Decrypt )
        {
            byte[] getpassword = Convert.FromBase64String( data2Decrypt );

            //read ciphertext, decrypt it to plaintext	
            byte[] plain =	rsa.Decrypt( getpassword, false );
            return System.Text.Encoding.UTF8.GetString( plain );
        }
        #endregion
    }
}
