using System;
using System.Runtime.InteropServices;

namespace XNADash
{
#if WINDOWS || XBOX
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        static void Main(string[] args)
        {
            using (DashGame game = new DashGame())
            {
                try
                {
                    game.Run();
                }
                catch ( Exception ex )
                {
                    MessageBox( 0, ex.Message, "Oops!", 0 );
                }
            }
        }

        [DllImport( "user32.dll", CharSet = CharSet.Auto )]
        public static extern uint MessageBox( int hWnd, String text, String caption, uint type );
    }
#endif
}

