﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.IO;
using XNADash.BoardBlocks;

namespace XNADash.Levels
{
    public class LevelFactory
    {
        class LevelReader
        {
            public LevelReader()
            {
            }

            List<DashBoard> _levels;
            public List<DashBoard> Levels
            {
                get
                {
                    if ( _levels == null )
                    {
                        _levels = new List<DashBoard>();

                        XmlDocument xd = new XmlDocument();
                        using ( FileStream fs = new FileStream( Path.Combine( DashGame.ExecutableDirrectory, "Levels\\LevelInfo.xml" ), FileMode.Open ) )
                            xd.Load( fs );

                        foreach ( XmlNode levelNode in xd.SelectNodes( "//levelInfo/level" ) )
                            _levels.Add( this.GetBoardFromXml( levelNode ) );
                    }

                    return _levels;
                }
            }

            private DashBoard GetBoardFromXml( XmlNode levelNode )
            {
                DashBoard board = new DashBoard();

                board.LevelName   = levelNode.Attributes["Name"].Value;
                board.LevelAuthor = levelNode.Attributes["Author"].Value;

                int rowNumber = 0;
                foreach ( XmlNode rowNode in levelNode.SelectNodes( "row" ) )
                {
                    string rowData = rowNode.Attributes["data"].Value;

                    int colNumber = 0;
                    foreach ( char cellData in rowData.ToCharArray() )
                    {
                        switch ( cellData )
                        {
                            case '$':
                                board.AddBlock( new HeartBlock() { Y = rowNumber, X = colNumber } );
                                break;

                            case '@':
                                board.AddBlock( new StoneBlock() { Y = rowNumber, X = colNumber } );
                                break;

                            case '.':
                                board.AddBlock( new GrassBlock() { Y = rowNumber, X = colNumber } );
                                break;

                            case '*':
                                board.AddBlock( new PlayerBlock() { Y = rowNumber, X = colNumber } );
                                break;

                            case '!':
                                board.AddBlock( new ExitBlock() { Y = rowNumber, X = colNumber } );
                                break;

                            case 'B':
                                board.AddBlock( new BombBlock() { Y = rowNumber, X = colNumber } );
                                break;

                            case '=':
                                board.AddBlock( new PlasmBlock() { Y = rowNumber, X = colNumber } );
                                break;

                            case '%' : case '#' : 
                                board.AddBlock( new WallBlock() { Y = rowNumber, X = colNumber } );
                                break;
                        }

                        colNumber++;
                    }

                    rowNumber++;
                }

                return board;
            }
        }

        LevelReader reader = new LevelReader();

        public LevelFactory()
        {
            this.Reset();
        }

        private static LevelFactory _instance;
        public static LevelFactory Instance
        {
            get
            {
                if ( _instance == null )
                    _instance = new LevelFactory();

                return _instance;
            }
        }

        public void Reset()
        {
            reader = new LevelReader();
        }

        public IEnumerable<DashBoard> Levels        
        {
            get
            {
                return reader.Levels;
            }
        }
    }
}
