﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using XNADash.Textures;
using XNADash.Sound;

namespace XNADash.BoardBlocks
{
    public class PlayerBlock : BaseBlock
    {
        protected override GameTexture BlockTexture
        {
            get
            {
                return GameTexture.Player;
            }
        }

        public void UpdatePosition( DashBoard Board, Directions Direction )
        {
            BaseBlock block = this.GetNeighbour( Direction );

            if ( block == null || block.CanBeConsumed )
                this.MoveTo( Direction );
            if ( block != null && block.CanBeConsumed )
            {
                if ( block is HeartBlock )
                {
                    Board.HeartsEaten++;
                    SoundFactory.Instance.PlayEffect( SoundType.Heart );
                }
                if ( block is ExitBlock )
                {
                    SoundFactory.Instance.PlayEffect( SoundType.Exit );
                }
                Board.RemoveBlock( block );
            }

            // przypadki specjalne
            if ( block != null && block.CanBePushed &&
                 (
                     (
                       Direction == Directions.E &&                 
                       block.GetNeighbour( Directions.E ) == null
                      )
                      ||
                     (
                       Direction == Directions.W &&                 
                       block.GetNeighbour( Directions.W ) == null
                      )
                  )
                )
            {
                this.MoveTo( Direction );
                block.MoveTo( Direction );
            }
        }
    }
}
