﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using XNADash.Textures;
using XNADash.Sound;

namespace XNADash.BoardBlocks
{
    public class BombBlock : BaseBlock
    {
        protected override GameTexture BlockTexture
        {
            get
            {
                return GameTexture.Bomb;
            }
        }

        public override bool DoesFall
        {
            get
            {
                return true;
            }
        }

        public override bool CanBePushed
        {
            get
            {
                return true;
            }
        }

        public bool MustExplode = false;
        public void Explode()
        {
            SoundFactory.Instance.PlayEffect( SoundType.Bomb );

            this.ExplodeNeighbour( Directions.None );
            this.ExplodeNeighbour( Directions.S );
            this.ExplodeNeighbour( Directions.E );
            this.ExplodeNeighbour( Directions.W );
            this.ExplodeNeighbour( Directions.N );
        }

        public override bool ApplyPhysics()
        {
            base.ApplyPhysics();

            if ( 
                this.MustExplode ||
                 (
                   this.IsFalling &&
                   this.GetNeighbour( Directions.S ) != null &&
                   this.GetNeighbour( Directions.S ).TriggersExplosion 
                  )
                )
            {
                this.Explode();
            }

            return false;
        }
    }
}
