// created on 2003-02-14 at 21:22
using System;
using System.Windows.Forms;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace NTRILMA
{
	public class f_TrilmaAbout : System.Windows.Forms.Form
	{
		public f_TrilmaAbout()
		{
			this.SetStyle(ControlStyles.DoubleBuffer, true);
			this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);

			InitializeComponent();
		}
						
		void InitializeComponent() {
			// 
			// f_TrilmaAbout
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(266, 87);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "f_TrilmaAbout";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "About...";
		}
		
    protected override void OnPaint( PaintEventArgs e )
    {
      base.OnPaint( e );

      using ( FontFamily ft = new FontFamily( "Tahoma" ) )
      {
        StringFormat sf = new StringFormat();
        sf.Alignment    = sf.LineAlignment = StringAlignment.Center;

        Rectangle r     = this.ClientRectangle;

        GraphicsPath gp = new GraphicsPath();
        gp.AddString( "Trilma.NET", ft, 1, 36, r, sf );

        e.Graphics.ScaleTransform( 1.0f, 3.0f );
        e.Graphics.TranslateTransform( 0, -r.Height/3 );
        e.Graphics.SmoothingMode = SmoothingMode.HighQuality;

        using ( LinearGradientBrush lgb = 
                new LinearGradientBrush( r, Color.Red, Color.Blue, LinearGradientMode.BackwardDiagonal ) )
        {
          e.Graphics.FillPath( lgb, gp );
          using ( Pen p = new Pen( Color.Black, 2 ) )
          {
            e.Graphics.DrawPath( p, gp );
          }
        }
      }		
	}
  }
}
