// created on 2003-01-31 at 22:11

using System;
using System.Collections;
using System.Drawing;

namespace NTRILMA
{
	public class TrilmaMove
	{ 
	 	public Point srcPoint;
	 	public Point destPoint;
		
		private TrilmaMove() {}
		public TrilmaMove( Point SourcePoint, Point DestinationPoint) 
		{
			srcPoint  = SourcePoint;
			destPoint = DestinationPoint;
		}
				
		public override string ToString()
		{
			return String.Format( "[{0}-{1}]", srcPoint, destPoint );
		}
	}
	
	public class TrilmaMoveSequence 
	{
		public ArrayList Moves = new ArrayList();
		
		public int MoveValue( TrilmaBoard Board )
		{
			if ( Moves.Count > 0 )
			{
				// compute new board layout
				TrilmaMove fMove = (TrilmaMove)Moves[0];
				TrilmaMove lMove = (TrilmaMove)Moves[Moves.Count-1]; 
				
				Board.theBoard[ fMove.srcPoint.X, fMove.srcPoint.Y ].Piece = 
					TrilmaSquare.EMPTY;
				Board.theBoard[ lMove.destPoint.X, lMove.destPoint.Y].Piece = 
					Board.currentPlayer;
				
				TrilmaPlayer tPlayer = Board.trilmaPlayers[ Board.currentPlayer ];
				
				int i,j, iMult;
				int value = 0;
				for ( i=0; i<TrilmaBoard.BOARD_SIZE; i++ )
					for ( j=0; j<TrilmaBoard.BOARD_SIZE; j++ )
						if ( Board.theBoard[i,j].Piece == tPlayer.plNumber )
						{
							Point bPoint = new Point(i,j);

							foreach ( Point endPoint in tPlayer.plEndPos )
							{
								// add the bonus for empty squares (?)
								if ( Board.theBoard[endPoint.X, endPoint.Y].Piece == TrilmaSquare.EMPTY )
									iMult = 2;
								else
									iMult = 1;
								value -= iMult * Board.CalculateDistance( bPoint, endPoint );
							}
							value -= TrilmaBoard.NO_PLAYER_PCS * Board.CalculateDistance( bPoint, tPlayer.plEndPoint );
						}
						
				// restore old layout						
				Board.theBoard[ fMove.srcPoint.X, fMove.srcPoint.Y ].Piece = 
					Board.currentPlayer;
				Board.theBoard[ lMove.destPoint.X, lMove.destPoint.Y].Piece = 
					TrilmaSquare.EMPTY;
						
				return value;
			}
			else
				throw new Exception( "Empty move has no value!" );
		}
								
		public override string ToString()
		{
			string sRet = String.Empty;
			
			foreach ( TrilmaMove Move in Moves )
				sRet += Move.ToString()+",";
			
			return sRet;
		}

		public TrilmaMoveSequence( TrilmaMoveSequence oldSeq )
		{			
			// make a copy of all moves
			foreach ( TrilmaMove m in oldSeq.Moves )
				this.Moves.Add( m );
			
		}
		
		public TrilmaMoveSequence() {}
	}
}
