using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

// Wiktor Zychla, 19.VII.2002

namespace vicMazeGen
{
	public class frmMain : System.Windows.Forms.Form
	{
		int msx;
		int msy;
		int bsx;
		int bsy;
		int seed;
		cMaze   myMaze;	
		Bitmap  myMazeBitmap;

		private System.Windows.Forms.PictureBox picMaze;
		private System.Windows.Forms.GroupBox gMaze1;
		private System.Windows.Forms.GroupBox cbMaze;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox txtMSX;
		private System.Windows.Forms.TextBox txtMSY;
		private System.Windows.Forms.GroupBox gBitmap;
		private System.Windows.Forms.TextBox txtBSY;
		private System.Windows.Forms.TextBox txtBSX;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label lblSeed;
		private System.Windows.Forms.TextBox txtSeed;
		private System.Windows.Forms.Button btCreate;
		private System.Windows.Forms.Button btSave;
		private System.Windows.Forms.Label lblQ1;
		private System.Windows.Forms.Label lblStatus;
		private System.Windows.Forms.Button btAbout;
		private System.ComponentModel.Container components = null;

		public frmMain()
		{
			InitializeComponent();
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.picMaze = new System.Windows.Forms.PictureBox();
			this.gMaze1 = new System.Windows.Forms.GroupBox();
			this.cbMaze = new System.Windows.Forms.GroupBox();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.txtMSX = new System.Windows.Forms.TextBox();
			this.txtMSY = new System.Windows.Forms.TextBox();
			this.gBitmap = new System.Windows.Forms.GroupBox();
			this.txtBSY = new System.Windows.Forms.TextBox();
			this.txtBSX = new System.Windows.Forms.TextBox();
			this.label3 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.lblSeed = new System.Windows.Forms.Label();
			this.txtSeed = new System.Windows.Forms.TextBox();
			this.btCreate = new System.Windows.Forms.Button();
			this.btSave = new System.Windows.Forms.Button();
			this.lblQ1 = new System.Windows.Forms.Label();
			this.lblStatus = new System.Windows.Forms.Label();
			this.btAbout = new System.Windows.Forms.Button();
			this.gMaze1.SuspendLayout();
			this.cbMaze.SuspendLayout();
			this.gBitmap.SuspendLayout();
			this.SuspendLayout();
			// 
			// picMaze
			// 
			this.picMaze.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.picMaze.Location = new System.Drawing.Point(4, 4);
			this.picMaze.Name = "picMaze";
			this.picMaze.Size = new System.Drawing.Size(512, 512);
			this.picMaze.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picMaze.TabIndex = 0;
			this.picMaze.TabStop = false;
			// 
			// gMaze1
			// 
			this.gMaze1.Controls.AddRange(new System.Windows.Forms.Control[] {
																				 this.txtSeed,
																				 this.lblSeed,
																				 this.gBitmap,
																				 this.cbMaze});
			this.gMaze1.Location = new System.Drawing.Point(520, 4);
			this.gMaze1.Name = "gMaze1";
			this.gMaze1.Size = new System.Drawing.Size(116, 200);
			this.gMaze1.TabIndex = 1;
			this.gMaze1.TabStop = false;
			this.gMaze1.Text = "Maze params";
			// 
			// cbMaze
			// 
			this.cbMaze.Controls.AddRange(new System.Windows.Forms.Control[] {
																				 this.txtMSY,
																				 this.txtMSX,
																				 this.label2,
																				 this.label1});
			this.cbMaze.ForeColor = System.Drawing.Color.Blue;
			this.cbMaze.Location = new System.Drawing.Point(4, 20);
			this.cbMaze.Name = "cbMaze";
			this.cbMaze.Size = new System.Drawing.Size(108, 72);
			this.cbMaze.TabIndex = 0;
			this.cbMaze.TabStop = false;
			this.cbMaze.Text = "Maze";
			// 
			// label1
			// 
			this.label1.ForeColor = System.Drawing.SystemColors.ControlText;
			this.label1.Location = new System.Drawing.Point(8, 24);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(36, 12);
			this.label1.TabIndex = 0;
			this.label1.Text = "sizeX:";
			// 
			// label2
			// 
			this.label2.ForeColor = System.Drawing.SystemColors.ControlText;
			this.label2.Location = new System.Drawing.Point(8, 48);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(36, 12);
			this.label2.TabIndex = 1;
			this.label2.Text = "sizeY:";
			// 
			// txtMSX
			// 
			this.txtMSX.Location = new System.Drawing.Point(44, 20);
			this.txtMSX.Name = "txtMSX";
			this.txtMSX.Size = new System.Drawing.Size(60, 20);
			this.txtMSX.TabIndex = 2;
			this.txtMSX.Text = "64";
			// 
			// txtMSY
			// 
			this.txtMSY.Location = new System.Drawing.Point(44, 44);
			this.txtMSY.Name = "txtMSY";
			this.txtMSY.Size = new System.Drawing.Size(60, 20);
			this.txtMSY.TabIndex = 3;
			this.txtMSY.Text = "64";
			// 
			// gBitmap
			// 
			this.gBitmap.Controls.AddRange(new System.Windows.Forms.Control[] {
																				  this.txtBSY,
																				  this.txtBSX,
																				  this.label3,
																				  this.label4});
			this.gBitmap.ForeColor = System.Drawing.Color.Red;
			this.gBitmap.Location = new System.Drawing.Point(4, 96);
			this.gBitmap.Name = "gBitmap";
			this.gBitmap.Size = new System.Drawing.Size(108, 72);
			this.gBitmap.TabIndex = 1;
			this.gBitmap.TabStop = false;
			this.gBitmap.Text = "Bitmap";
			// 
			// txtBSY
			// 
			this.txtBSY.Location = new System.Drawing.Point(44, 44);
			this.txtBSY.Name = "txtBSY";
			this.txtBSY.Size = new System.Drawing.Size(60, 20);
			this.txtBSY.TabIndex = 3;
			this.txtBSY.Text = "512";
			// 
			// txtBSX
			// 
			this.txtBSX.Location = new System.Drawing.Point(44, 20);
			this.txtBSX.Name = "txtBSX";
			this.txtBSX.Size = new System.Drawing.Size(60, 20);
			this.txtBSX.TabIndex = 2;
			this.txtBSX.Text = "512";
			// 
			// label3
			// 
			this.label3.ForeColor = System.Drawing.SystemColors.ControlText;
			this.label3.Location = new System.Drawing.Point(8, 48);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(36, 12);
			this.label3.TabIndex = 1;
			this.label3.Text = "sizeY:";
			// 
			// label4
			// 
			this.label4.ForeColor = System.Drawing.SystemColors.ControlText;
			this.label4.Location = new System.Drawing.Point(8, 24);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(36, 12);
			this.label4.TabIndex = 0;
			this.label4.Text = "sizeX:";
			// 
			// lblSeed
			// 
			this.lblSeed.Location = new System.Drawing.Point(4, 176);
			this.lblSeed.Name = "lblSeed";
			this.lblSeed.Size = new System.Drawing.Size(40, 12);
			this.lblSeed.TabIndex = 2;
			this.lblSeed.Text = "Seed:";
			// 
			// txtSeed
			// 
			this.txtSeed.Location = new System.Drawing.Point(48, 172);
			this.txtSeed.Name = "txtSeed";
			this.txtSeed.Size = new System.Drawing.Size(64, 20);
			this.txtSeed.TabIndex = 3;
			this.txtSeed.Text = "0";
			// 
			// btCreate
			// 
			this.btCreate.Location = new System.Drawing.Point(520, 212);
			this.btCreate.Name = "btCreate";
			this.btCreate.Size = new System.Drawing.Size(116, 28);
			this.btCreate.TabIndex = 2;
			this.btCreate.Text = "Create maze";
			this.btCreate.Click += new System.EventHandler(this.btCreate_Click);
			// 
			// btSave
			// 
			this.btSave.Location = new System.Drawing.Point(520, 248);
			this.btSave.Name = "btSave";
			this.btSave.Size = new System.Drawing.Size(116, 28);
			this.btSave.TabIndex = 3;
			this.btSave.Text = "Save maze";
			this.btSave.Click += new System.EventHandler(this.btSave_Click);
			// 
			// lblQ1
			// 
			this.lblQ1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblQ1.Location = new System.Drawing.Point(4, 520);
			this.lblQ1.Name = "lblQ1";
			this.lblQ1.Size = new System.Drawing.Size(44, 16);
			this.lblQ1.TabIndex = 4;
			this.lblQ1.Text = "Status:";
			this.lblQ1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblStatus
			// 
			this.lblStatus.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblStatus.Location = new System.Drawing.Point(52, 520);
			this.lblStatus.Name = "lblStatus";
			this.lblStatus.Size = new System.Drawing.Size(464, 16);
			this.lblStatus.TabIndex = 5;
			this.lblStatus.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// btAbout
			// 
			this.btAbout.Location = new System.Drawing.Point(520, 484);
			this.btAbout.Name = "btAbout";
			this.btAbout.Size = new System.Drawing.Size(116, 32);
			this.btAbout.TabIndex = 6;
			this.btAbout.Text = "About...";
			this.btAbout.Click += new System.EventHandler(this.btAbout_Click);
			// 
			// frmMain
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(638, 543);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.btAbout,
																		  this.lblStatus,
																		  this.lblQ1,
																		  this.btSave,
																		  this.btCreate,
																		  this.gMaze1,
																		  this.picMaze});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "frmMain";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "TorqMaze 0.01";
			this.gMaze1.ResumeLayout(false);
			this.cbMaze.ResumeLayout(false);
			this.gBitmap.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
		#region Controls
		private void btCreate_Click(object sender, System.EventArgs e)
		{
			// do all checks
			if ( !cVaria.IsNumeric( txtMSX.Text ) ||
				 !cVaria.IsNumeric( txtMSY.Text ) ||
				 !cVaria.IsNumeric( txtBSX.Text ) ||
				 !cVaria.IsNumeric( txtBSY.Text ) ||
 			     !cVaria.IsNumeric( txtSeed.Text ) 
				)
				{
					MessageBox.Show ( "Parameters should be numeric.", "Bad parameters", MessageBoxButtons.OK, MessageBoxIcon.Warning ); 
					return;
				}

			msx  = int.Parse ( txtMSX.Text );
			msy  = int.Parse ( txtMSY.Text );
			bsx  = int.Parse ( txtBSX.Text );
			bsy  = int.Parse ( txtBSY.Text );
			seed = int.Parse ( txtSeed.Text );

			if ( ( msx<2 ) || ( msx > 4096 ) ||
				 ( msy<2 ) || ( msx > 4096 ) )
			{
				MessageBox.Show ( "Valid range for maze size: [2-4096].", "Bad parameters", MessageBoxButtons.OK, MessageBoxIcon.Warning ); 
				return;
			}

			if ( 2*msx > bsx || 2*msy > bsy )
			{
				MessageBox.Show ( "Bitmap size should be at least twice as much as maze size.", "Bad parameters", MessageBoxButtons.OK, MessageBoxIcon.Warning ); 
				return;
			}
			if ( bsx > 512 || bsy > 512 )
			{
				MessageBox.Show ( "The image in a window could be distorted. Save maze to disk and view it outside this program.", "", MessageBoxButtons.OK, MessageBoxIcon.Information ); 
			}


			// create global maze
			myMaze = new cMaze();				
		
			lblStatus.Text = "Generating the maze..."; 
			lblStatus.Refresh(); 

			myMaze.GenerateMaze( msx, msy, seed );

			lblStatus.Text = "Generating the maze image..."; 
			lblStatus.Refresh(); 

			myMazeBitmap = myMaze.GetBitmap( bsx, bsy );		

			picMaze.Image = myMazeBitmap;

			lblStatus.Text = "Ready..."; 
			lblStatus.Refresh(); 
		}

		private void btSave_Click(object sender, System.EventArgs e)
		{
			if ( myMaze == null )
			{
				MessageBox.Show ( "The maze has to be created first.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning );
				return;
			}		
			SaveFileDialog sF  = new SaveFileDialog();
			sF.OverwritePrompt = true;
			sF.Title           = "Save maze...";
			sF.Filter          = "Images JPEG (*.jpg)|*.jpg|Images BMP (*.bmp)|*.bmp|Images PNG (*.png)|*.png|Wszystkie pliki (*.*)|*.*";
 
			sF.ShowDialog( this );

			if ( sF.FileName == String.Empty ) return;

			if ( sF.FileName.EndsWith("jpg") )
				myMazeBitmap.Save ( sF.FileName, ImageFormat.Jpeg );
			else
				if ( sF.FileName.EndsWith("png") )
				myMazeBitmap.Save ( sF.FileName, ImageFormat.Png );
			else
				if ( sF.FileName.EndsWith("bmp") )
				myMazeBitmap.Save ( sF.FileName, ImageFormat.Bmp );
			else
				myMazeBitmap.Save ( sF.FileName, ImageFormat.Bmp );
			MessageBox.Show ( "Maze image saved." );		
		}

		#endregion

		private void btAbout_Click(object sender, System.EventArgs e)
		{
			(new frmAbout()).ShowDialog();
		}

	}
}
