#include <windows.h>
#include <process.h>
#include <stdio.h>

#include "partia.h"
#include "WinMain.h"

#define winX 278
#define winY 370

// Constants
               
// Variables
char szClassName[]   = "TorqChessClass";
char szWindowTitle[] = "TorqChess 0.01a";

HINSTANCE thisInstance = NULL;

CMoveInfo plyMove = CMoveInfo(-1, -1, -1, -1, I_PUSTE);
bool plyIsPlaying = false;
bool plyGetMove   = false;
char plyMovePoint = 0;            // czy wprowadza si pocztek czy koniec posunicia
int boardPosX     = 10;
int boardPosY     = 15;

HWND    hwnd;               
HBITMAP hbmPieces[26];
BITMAP  bm;

CPartia* partia;

// Forward declarations
LRESULT CALLBACK WindowProcedure(HWND, UINT, WPARAM, LPARAM);
int LoadPiecesFromResource(HWND hwnd);
VOID Thread (PVOID pvoid);

void WypiszDummySzach(HWND hwnd);

int WINAPI WinMain(HINSTANCE hThisInstance, HINSTANCE hPrevInstance, 
                   LPSTR lpszArgument, int nFunsterStil)

{
    MSG messages;            
    WNDCLASSEX wincl;        
    
    thisInstance = hThisInstance;

    wincl.cbSize = sizeof(WNDCLASSEX);
    wincl.hInstance = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc = WindowProcedure;      
    wincl.style = 0;      
    wincl.cbClsExtra = 0;                      
    wincl.cbWndExtra = 0;                      

    wincl.hIcon = LoadIcon(thisInstance, "IKONKA"); 
    wincl.hIconSm = NULL; 
    wincl.hCursor = LoadCursor(NULL, IDC_ARROW);
    wincl.lpszMenuName = "MAINMENU"; 

    wincl.hbrBackground = (HBRUSH) (COLOR_BTNFACE+1); 

    if(!RegisterClassEx(&wincl)) return 0;

    hwnd = CreateWindowEx(
           0,                   
           szClassName,         
           szWindowTitle,     
           WS_OVERLAPPED | WS_SYSMENU | WS_MINIMIZEBOX, 
           CW_USEDEFAULT, CW_USEDEFAULT,       
           winX, winY,                 
           HWND_DESKTOP,        
           NULL,                
           hThisInstance,       
           NULL                 
           );

    ShowWindow(hwnd, nFunsterStil);

    while(GetMessage(&messages, NULL, 0, 0))
    {
           TranslateMessage(&messages);
           DispatchMessage(&messages);
    }

    return messages.wParam;
}

BOOL CALLBACK About1WndProc (HWND hDlg, UINT message, 
                              WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK WindowProcedure(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    int xm, ym, res; 
    RECT rect;
    
    switch (message)                  
    {
           case WM_COMMAND:
                switch (LOWORD(wParam)) {
                   case CM_FILE_NEW: 
                                     if (plyIsPlaying) 
                                     {
                                       MessageBox(hwnd, 
                                         "Can't start a new game while playing.", 
                                         "", MB_OK);
                                       break;
                                     } 
                                     else
                                     { 
                                       plyIsPlaying = true; 
                                       _beginthread (Thread, 0, NULL);
                                     } 
                                     break;
                   case CM_FILE_EXIT:
                                     PostMessage(hwnd, WM_CLOSE, 0, 0);
                                     break;
                   case CM_ABOUT:
                                     DialogBox(thisInstance, "ABOUT1", hwnd, About1WndProc);                                      
                                     break;                  
                };
                break;
                
           case WM_CREATE:
           
                if (LoadPiecesFromResource(hwnd) == -1) return -1;
                                
                break;
                
           case WM_PAINT:
           
                PAINTSTRUCT ps;
                HDC hdcWindow;
                hdcWindow = BeginPaint(hwnd, &ps);
                
                if (partia != NULL) 
                  partia->szach->WypiszHWND(hwnd);
                  else
                  WypiszDummySzach(hwnd);
                
                EndPaint(hwnd, &ps);                
                
                break;        
                        
           case WM_LBUTTONDOWN:
           
                xm = LOWORD (lParam) - boardPosX;
                ym = HIWORD (lParam) - boardPosY;
                
                if (plyGetMove)
                {
                  if ( 
                       xm > boardPosX && ym > boardPosY &&
                       xm < boardPosX+10+8*bm.bmWidth && 
                       ym < boardPosY+10+8*bm.bmHeight
                     )
                     
                    if (plyMovePoint == 0)
                    {
                      plyMove.ys = (xm - 5)/bm.bmWidth;
                      plyMove.xs = 7 - ((ym - 5)/bm.bmHeight);
                      plyMovePoint++;
                    }  
                    else
                    {
                      plyMove.yd = (xm - 5)/bm.bmWidth;
                      plyMove.xd = 7 - ((ym - 5)/bm.bmHeight);
                      plyMovePoint--;
                    }  
                                
                  rect.left = boardPosX; rect.top = boardPosY;                
                  rect.right = boardPosX+10+8*bm.bmWidth; 
                  rect.bottom = boardPosY+10+8*bm.bmHeight;
                
                  InvalidateRect (hwnd, &rect, TRUE) ;
                
                } // if (plyGetMove...)   
                
                return 0 ;
               
           case WM_DESTROY:
           
                if (partia != NULL) delete partia;
                
                PostQuitMessage(0);        
                
                break;        
                        
           default:                   
           return DefWindowProc(hwnd, message, wParam, lParam);
    }
    return 0;
}

// --------------------------------------------------------------------------

int LoadPiecesFromResource(HWND hwnd)
{
         int i;
         char buf[80];
         // piony
         hbmPieces[BM_B_PION_B] = LoadBitmap(thisInstance, "R_B_PION_B");
         hbmPieces[BM_B_PION_C] = LoadBitmap(thisInstance, "R_B_PION_C");
         hbmPieces[BM_C_PION_B] = LoadBitmap(thisInstance, "R_C_PION_B");
         hbmPieces[BM_C_PION_C] = LoadBitmap(thisInstance, "R_C_PION_C");
         // wieze
         hbmPieces[BM_B_WIEZA_B] = LoadBitmap(thisInstance, "R_B_WIEZA_B");
         hbmPieces[BM_B_WIEZA_C] = LoadBitmap(thisInstance, "R_B_WIEZA_C");
         hbmPieces[BM_C_WIEZA_B] = LoadBitmap(thisInstance, "R_C_WIEZA_B");
         hbmPieces[BM_C_WIEZA_C] = LoadBitmap(thisInstance, "R_C_WIEZA_C");
         // skoczki
         hbmPieces[BM_B_SKOCZEK_B] = LoadBitmap(thisInstance, "R_B_SKOCZEK_B");
         hbmPieces[BM_B_SKOCZEK_C] = LoadBitmap(thisInstance, "R_B_SKOCZEK_C");
         hbmPieces[BM_C_SKOCZEK_B] = LoadBitmap(thisInstance, "R_C_SKOCZEK_B");
         hbmPieces[BM_C_SKOCZEK_C] = LoadBitmap(thisInstance, "R_C_SKOCZEK_C");
         // gonce
         hbmPieces[BM_B_GONIEC_B] = LoadBitmap(thisInstance, "R_B_GONIEC_B");
         hbmPieces[BM_B_GONIEC_C] = LoadBitmap(thisInstance, "R_B_GONIEC_C");
         hbmPieces[BM_C_GONIEC_B] = LoadBitmap(thisInstance, "R_C_GONIEC_B");
         hbmPieces[BM_C_GONIEC_C] = LoadBitmap(thisInstance, "R_C_GONIEC_C");
         // hetmany
         hbmPieces[BM_B_HETMAN_B] = LoadBitmap(thisInstance, "R_B_HETMAN_B");
         hbmPieces[BM_B_HETMAN_C] = LoadBitmap(thisInstance, "R_B_HETMAN_C");
         hbmPieces[BM_C_HETMAN_B] = LoadBitmap(thisInstance, "R_C_HETMAN_B");
         hbmPieces[BM_C_HETMAN_C] = LoadBitmap(thisInstance, "R_C_HETMAN_C");
         // krole
         hbmPieces[BM_B_KROL_B] = LoadBitmap(thisInstance, "R_B_KROL_B");
         hbmPieces[BM_B_KROL_C] = LoadBitmap(thisInstance, "R_B_KROL_C");
         hbmPieces[BM_C_KROL_B] = LoadBitmap(thisInstance, "R_C_KROL_B");
         hbmPieces[BM_C_KROL_C] = LoadBitmap(thisInstance, "R_C_KROL_C");
         // puste
         hbmPieces[BM_B_PUSTE] = LoadBitmap(thisInstance, "R_B_PUSTE");
         hbmPieces[BM_C_PUSTE] = LoadBitmap(thisInstance, "R_C_PUSTE");

         for (i=BM_B_PION_B; i<BM_C_PUSTE; i++)
          if(!hbmPieces[i])
          {
             sprintf(buf, "Resource error: %d", i);
             MessageBox(hwnd, buf, "Error",
                MB_OK | MB_ICONEXCLAMATION);
             return 1;
          }
          
         GetObject(hbmPieces[0], sizeof(bm), &bm); 
         
         return 0;
}

// --------------------------------------------------------------------------
// Dialog boxy

Gracz a, b;
BOOL CALLBACK Dialog1WndProc (HWND hDlg, UINT message, 
                              WPARAM wParam, LPARAM lParam)
{
     int i;
     char buf[80];
     static int dres;
     switch (message)
     {
     case WM_INITDIALOG :
          SendMessage (GetDlgItem (hDlg, CM_H_H),
                       BM_SETCHECK, 1, 0) ;
          dres = CM_H_H;             
          return TRUE ;
          
     case WM_COMMAND :
          switch (LOWORD (wParam))
          {
          case CM_H_H:
          case CM_C_H:
          case CM_H_C:
          case CM_C_C:
          for (i = CM_H_H; i <= CM_C_C; i++)
               SendMessage (GetDlgItem (hDlg, i),
                            BM_SETCHECK, i == LOWORD (wParam), 0) ;
          dres = LOWORD(wParam);            
          break;
          
          case IDOK :          
               switch( dres ) {
                  case CM_H_H: a = CZLOWIEK; b = CZLOWIEK; break;
                  case CM_H_C: a = CZLOWIEK; b = MASZYNA; break;
                  case CM_C_H: a = MASZYNA; b = CZLOWIEK; break;
                  case CM_C_C: a = MASZYNA; b = MASZYNA; break;
               };
               
               EndDialog (hDlg, 0) ;
               return TRUE ;
          }
          break ;
     }
     return FALSE ;
}

VOID Julia (HWND hAbout, int cx, int cy);
BOOL CALLBACK About1WndProc (HWND hDlg, UINT message, 
                              WPARAM wParam, LPARAM lParam)
{
     int cx, cy;
     static double ang1 = 0, ang2 = 0;
     const int idTimer1 = 1;
     const int nTimerDelay = 10;     
     
     switch (message)
     {
     case WM_INITDIALOG:
          SetTimer(hDlg, idTimer1, nTimerDelay, NULL);
          return TRUE ;

     case WM_TIMER: 
           cx = int(600*sin(ang1));
           cy = int(600*cos(ang2));
           ang1+=0.027; ang2+=0.033;     
           Julia(hDlg, cx, cy);
           break;
                     
     case WM_COMMAND :
          switch (LOWORD (wParam))
          {          
            case IDOK :                         
               KillTimer(hDlg, idTimer1);
               EndDialog (hDlg, 0) ;
               return TRUE ;
            break;   
          }
          break ;
          
     }
     return FALSE ;
}

VOID Julia (HWND hAbout, int cx, int cy)
{
  int i,j,px,py;
  int xn,yn,x2,y2,x,y;
  unsigned char c;
  const int aPx = 10, aPy = 26;
  
  HDC hdc;
  
  hdc = GetDC(hAbout);
  
    for (i=-2000,px=0;i<2000;i+=40,px++)
      for (j=-2000,py=0;j<2000;j+=80,py++)
      {
        c=0;
        x=i;y=j;
        x2=x*x;
        y2=y*y;
        while (((x2+y2)<4000000) && (c<31))
        {
          c++;

          xn = ((x2-y2)>>10)+cx;
          yn = ((x*y)>>9)+cy;
          
          x=xn;y=yn;
          x2=x*x;
          y2=y*y;
        }
        SetPixel(hdc, px+aPx, py+aPy, RGB( 8*c, 6*c, 255-2*c ));
      }
        
  DeleteDC(hdc);
  
}

// --------------------------------------------------------------------------

void PytajOGraczy()
{
   
  DialogBox(thisInstance, "DIALOG1", hwnd, Dialog1WndProc); 
  
}

VOID Thread (PVOID pvoid)
{
  int res = 0;
  static TCHAR* szMessage[] = { TEXT ("Black wins."),
                                TEXT ("Draw game."),
                                TEXT ("White wins.") } ;
  
  partia = new CPartia();
  if (!partia) return;
  
  PytajOGraczy();

  res = partia->Rozgrywka(a, b);

  MessageBox(hwnd, szMessage[res+1], "Result", MB_OK);

  delete partia;
  partia = NULL;

  plyIsPlaying = false; 
  
  _endthread();
  
}

// ------------------------------------------------------------------------------

void WypiszDummySzach(HWND hwnd)
{
   CSzachownica szach;
//   szach.UstawieniePoczatkowe();
   szach.WypiszHWND(hwnd);
}


