// -------------------------------------
//
// -------------------------------------

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include "partia.h"
#include "openbook.h"

extern HINSTANCE thisInstance;
extern HWND hwnd;
extern CMoveInfo plyMove;
extern bool plyGetMove;
extern bool plyIsPlaying;
extern BITMAP bm;
extern HBITMAP hbmPieces[26];

int przemBierka;

// -------------------------------------------------------

BOOL CALLBACK PrzemianaDialogWndProc (HWND hDlg, UINT message, 
                                      WPARAM wParam, LPARAM lParam);

// -------------------------------------------------------

CPartia::CPartia()
{
  szach = new CSzachownica;
  orh = new COpisRuchu;
  transp = new CTranspTable(18);
  WhaszujTabliceOtwarc(transp);
}

CPartia::~CPartia()
{
  if (szach) delete szach;
  if (orh) delete orh;
  if (transp) delete transp;
}

// -------------------------------------------------------

// wprowadzenie '!' konczy zabawe, break
// zwraca wspolrzedne pol ruchu albo ys = 33 - jesli wprowadzono '!'
CMoveInfo CzytajRuch(CSzachownica* szach)
{

  const int py = 18;

  bool ok, jwyb; // jwyb - jeden wybr
  int i;
  char buf[80];

  plyMove = CMoveInfo(-1, -1, -1, -1, I_PUSTE);

  plyGetMove = true;
  do 
  {
     Sleep(100);           // czekaj na posunicie!
  } while (
            (plyMove.xs == -1) || (plyMove.ys == -1) ||
            (plyMove.xd == -1) || (plyMove.yd == -1) 
          );
  plyGetMove = false;

  // jesli to akurat promocja piona to spytaj jeszcze na co go promowac
  if (
       (plyMove.xs == 6 && plyMove.xd == 7 && 
        szach->bierki[plyMove.xs][plyMove.ys] == I_BPION) ||
        
       (plyMove.xs == 1 && plyMove.xd == 0 && 
        szach->bierki[plyMove.xs][plyMove.ys] == I_CPION)
     )
  {
      przemBierka = -1;
                
      DialogBox(thisInstance, "PRZEMIANA", hwnd, PrzemianaDialogWndProc); 

      switch (przemBierka) {
      case 0 : plyMove.nacopromowac =
                 (szach->k_ruch==C_BIALE ? I_BWIEZA : I_CWIEZA);
                 ok = true;
                 break; // wieza
      case 1 : plyMove.nacopromowac =
                 (szach->k_ruch==C_BIALE ? I_BSKOCZEK : I_CSKOCZEK);
                 ok = true;
                 break; // skoczek
      case 2 : plyMove.nacopromowac =
                 (szach->k_ruch==C_BIALE ? I_BGONIEC : I_CGONIEC);
                 ok = true;
                 break; // goniec
      case 3 : plyMove.nacopromowac =
                 (szach->k_ruch==C_BIALE ? I_BHETMAN : I_CHETMAN);
                 ok = true;
                 break; // hetman
      };

  }  

  return plyMove;

}

// -------------------------------------------------------

// wynik: 1 - wygraly biale, -1 - wygraly czarne, 0 - pat
int CPartia::Rozgrywka(Gracz a, Gracz b)
{
  MoveStatus ms;
  char moveErrorBuf[80];

  bool koniec = false;          // koniec gry
  bool wczytruchok = false;     // wczytano poprawne posuniecie
  bool przesuwac = false;       // czy wczytano posuniecie czy pomoc etc.

  CMoveInfo move;

  szach->UstawieniePoczatkowe();
  orh->Init();

  do {

    bool s_w = (a == CZLOWIEK ? false : true);
    bool s_b = (b == CZLOWIEK ? false : true);

    szach->WypiszHWND(hwnd);

    // sprawdz czy jest pat, szach, mat albo 50 posuniec bez bicia
    // co 2 posuniecia
    if (szach->doremisu > 100)
    {
//      cprintf("50 posuniec bez zbicia bierki (%d)!", szach->doremisu);
      return 0;
    }

    if (szach->CzyJestSzach(orh))
    {
        if (szach->CzyJestMat(orh))
        {
//          cprintf("MAT!");
          return (szach->k_ruch == C_BIALE ? -1 : 1);
        }
//        else
//        cprintf("SZACH!");
    }
    else
    if (szach->CzyJestPat(orh))
    {
//      cprintf("PAT!");
      return 0;
    }
    else
//      cprintf("      ");

    szach->Dopiski(orh);

    // petla glowna, wczytuje posuniecia i symuluje gre
    // czy wczytac ruch gracza czy rusza komputer?
    if (
         (szach->k_ruch == C_BIALE && s_w == true) ||
         (szach->k_ruch == C_CZARNE && s_b == true)
       )
    {
      move = szach->AI(orh, transp, s_w, s_b);
      plyMove = move;  // przeka, aby zaznaczy warto 
      przesuwac = true;
    }
    else
    do
    {
       wczytruchok = false;
       przesuwac = false;

       move = CzytajRuch(szach);

       if ( (ms=szach->CzyRuchPoprawny(move, orh,
                                                 true, true))
                      !=MOVE_OK )
                 {
                   print_errorMOVE(ms, moveErrorBuf);
                   MessageBox(hwnd, moveErrorBuf, "Illegal move!", 
                              MB_OK | MB_ICONEXCLAMATION);
                 }
                 else
                 {
                   wczytruchok = true;
                   przesuwac = true;
                 }  
       
    } while (wczytruchok == false);

    // jesli trzeba dokonac zmian na planszy
    if (przesuwac == true)
    {
      if (move.xs!=BK)
      {
        szach->PrzesunBierke(move);
        szach->PrzeciwnaStronaGra();
        MessageBeep(MB_OK);
      }
    }

  } while (!koniec);

  return 0;

}

// --------------------------------------------------------------------------

int PIndex(int i)
{
   int res;

   switch (i) {
      case 0: res = BM_B_WIEZA_B;   break;
      case 1: res = BM_B_SKOCZEK_B; break;
      case 2: res = BM_B_GONIEC_B;  break;
      case 3: res = BM_B_HETMAN_B;  break; 
   }
   
   return res;
}

void NarysujObrazkiFigur(HDC hdc)
{
     int i;
     HDC hdcMemory;
     HPEN hPenRed3;
     
     hdcMemory = CreateCompatibleDC(hdc);

     for (i = 0; i < 4; i++)
     {
           SelectObject( hdcMemory, 
                         hbmPieces[ PIndex(i) ]
                       );
           BitBlt(hdc, 20+i*(bm.bmWidth+10), 
                       30, 
                       bm.bmWidth, bm.bmHeight, 
                       hdcMemory, 0, 0, SRCCOPY);
     }
     
     hPenRed3 = CreatePen (PS_SOLID, 1, RGB(255, 0, 0)) ;
     SelectObject(hdc, hPenRed3);
     SelectObject (hdc, GetStockObject (NULL_BRUSH) ) ;                
     
     Rectangle( hdc, 20+przemBierka*(bm.bmWidth+10),
                     30,
                     20+przemBierka*(bm.bmWidth+10)+bm.bmWidth,
                     30+bm.bmHeight
              );

     DeleteObject(hPenRed3);               
     DeleteDC(hdcMemory);  
}

BOOL CALLBACK PrzemianaDialogWndProc (HWND hDlg, UINT message, 
                                      WPARAM wParam, LPARAM lParam)
{
     int xm, ym, fig;
     int i;
     HDC hdc;

     switch (message)
     {
     
          case WM_LBUTTONDOWN:           

               fig = -1;
               xm = LOWORD (lParam);
               ym = HIWORD (lParam);
                                             
               if ( ym > 30 && ym < 30 + bm.bmHeight )
               {
                  for (i=0; i<4; i++)
                    if ( xm > 20+i*(bm.bmWidth+10) && 
                         xm < 20+(i+1)*(bm.bmWidth+10)
                       )  
                       fig = i;  
               }
               if (fig == -1) return TRUE;
               
               przemBierka = fig;               
               // maluj to czerwone
               hdc = GetDC(hDlg);               
               NarysujObrazkiFigur(hdc);                              
               DeleteDC(hdc);
                                   
               return TRUE;
     
          // narysuj obrazki figur
          case WM_PAINT:
               PAINTSTRUCT ps;
               HDC hdcWindow;
               hdcWindow = BeginPaint(hDlg, &ps);
               NarysujObrazkiFigur(hdcWindow);                
               EndPaint(hDlg, &ps);                
               return TRUE;
     
          case WM_INITDIALOG:
               przemBierka = 3;
               return TRUE ;

          case WM_COMMAND :
            switch (LOWORD (wParam)) {          
                 case IDOK :                                   
                    EndDialog (hDlg, 0) ;
                    return TRUE ;
                    break;
            }        
     }
     return FALSE ;
}

// --------------------------------------------------------------------------

