#include <stdlib.h>

#include "moves_n.h"
#include "szachow.h"

//-----------------------------------------------------
// tworzy drzewo (ale na razie glebok. 1) kolejnych ruchow
// n_test przekazywany jest do CzyRuchPoprawny

CNode* KolejneRuchy(CSzachownica* szach, COpisRuchu* orh, bool n_test)
{
  CNode* root = new CNode;
  int i,j,k;
  char sx, sy, dx, dy;  // source x,y, dest x, y
  int i1, i2, i3, j1, j2, j3;     // przyspieszacze petli

  root->el = (void*)szach;

  if ( szach->k_ruch == C_BIALE )
  { i1 = j1 = 0    ; i2 = j2 = 8*8; i3 = j3 = 1; }
  else
  { i1 = j1 = 8*8-1; i2 = j2 = -1 ; i3 = j3 = -1; }

  // tutaj MUSI byc tablica 'killer moves'!
  for (i=i1; i!=i2; i+=i3)
    for (j=j1; j!=j2; j+=j3)
     if ( szach->bierki[i/8][i%8] != I_PUSTE ) // usprawnienie!
     if ( KolorBierki( szach->bierki[i/8][i%8] ) == szach->k_ruch )
      if (
           szach->CzyRuchPoprawny(
                                  CMoveInfo(
                                             sx = i/8, sy = i%8,
                                             dx = j/8, dy = j%8, I_PUSTE
                                           ),
                                  orh, true, n_test
                                 )
                                 == MOVE_OK
         )
      {
        // wykryj specjaln sytuacje, w ktorej
        // nastepuje przemiana piona i trzeba dodac az 4 mozliwosci
        // do listy mozliwych ruchow
        if (
             (sx == 6 && dx == 7 && szach->bierki[sx][sy] == I_BPION) ||
             (sx == 1 && dx == 0 && szach->bierki[sx][sy] == I_CPION)
           )
           {
             // sa 4 mozliwosci nowej sytuacji: dodanie W, S, G, H
             for (k=0; k<4; k++)
             {
               CSzachownica* tszach = new CSzachownica(*szach);
               CMoveInfo move(sx, sy, dx, dy, I_PUSTE);

               switch (k) {
               case 0 : move.nacopromowac =
                        (tszach->k_ruch == C_BIALE ? I_BWIEZA : I_CWIEZA);
                        break;
               case 1 : move.nacopromowac =
                        (tszach->k_ruch == C_BIALE ? I_BSKOCZEK : I_CSKOCZEK);
                        break;
               case 2 : move.nacopromowac =
                        (tszach->k_ruch == C_BIALE ? I_BGONIEC : I_CGONIEC);
                        break;
               case 3 : move.nacopromowac =
                        (tszach->k_ruch == C_BIALE ? I_BHETMAN : I_CHETMAN);
                        break;
               }

               tszach->PrzesunBierke(move);
               tszach->PrzeciwnaStronaGra();
               tszach->pm = move;

               root->AddChild(tszach);
             }
           }
           else
           // po prostu jeden ruch
           {
             CSzachownica* tszach = new CSzachownica(*szach);

             tszach->PrzesunBierke(CMoveInfo(sx, sy, dx, dy, I_PUSTE));
             tszach->PrzeciwnaStronaGra();
             tszach->pm.xs = sx; tszach->pm.ys = sy;
             tszach->pm.xd = dx; tszach->pm.yd = dy;

             root->AddChild(tszach);
           }
      }

  return root;
};

//-----------------------------------------------------

bool SzukajKrolaNaLiscie(CNode* root, bool s_ruch)
{
  CNode* tmp;

  tmp = root->children;
  while (tmp!=NULL)
  {
//    ((CSzachownica*)tmp->el)->WypiszCONIO(40, 1);getch();
    if ( ((CSzachownica*)tmp->el)->ZnajdzWspolrzedneKrola(!s_ruch) == -1)
      return false;
    tmp = tmp->next;
  }
  return true;
}

//-----------------------------------------------------
// ma liste dzieciakow i wypisuje posuniecia
void WypiszKolejneRuchy(CSzachownica* szach, COpisRuchu* orh,
                        char px, char py)
{
  int i;
  char cZnak;
  CSzachownica* tmp;
  CNode* root;

  root = KolejneRuchy(szach, orh, true);

//  gotoxy(px, py);

  for (i=0; i<root->CountChildren(); i++)
  {
    tmp = (CSzachownica*)root->Child(i)->el;
    switch(tmp->bierki[tmp->pm.xd][tmp->pm.yd]) {
     case I_PUSTE       : cZnak = ' ';break;
     case I_BPION	: cZnak	= 'P';break;
     case I_BWIEZA	: cZnak	= 'W';break;
     case I_BSKOCZEK	: cZnak	= 'S';break;
     case I_BGONIEC	: cZnak	= 'G';break;
     case I_BHETMAN	: cZnak	= 'H';break;
     case I_BKROL	: cZnak	= 'K';break;
     case I_CPION	: cZnak	= 'p';break;
     case I_CWIEZA	: cZnak	= 'w';break;
     case I_CSKOCZEK	: cZnak	= 's';break;
     case I_CGONIEC	: cZnak	= 'g';break;
     case I_CHETMAN	: cZnak	= 'h';break;
     case I_CKROL	: cZnak	= 'k';break;
    }
//    cprintf( "%c%c%c-%c%c  ", cZnak,
//                              65+tmp->pm.ys, 49+tmp->pm.xs,
//                              65+tmp->pm.yd, 49+tmp->pm.xd );
  }

  root->RemoveChildren();
  delete root;

}




