// -------------------------------------
//
// -------------------------------------

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <time.h>
#include <string.h>

#include "szachow.h"
#include "moves_n.h"
#include "eval.h"
#include "openbook.h"

int INFTY = 10000;

int min_depth = 3;
int max_depth = 5;
int main_depth;

clock_t s, e;

extern HWND hwnd;
extern BITMAP bm;
extern HBITMAP hbmPieces[26];
extern CMoveInfo plyMove;
extern int boardPosX; 
extern int boardPosY; 

void SpeedOutput();

// pozycja pusta
const char PPos[8][8] =
  {{I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE }};

// pozycja wyjsciowa
const char SPos[8][8] =
  {{I_CWIEZA, I_CSKOCZEK, I_CGONIEC, I_CHETMAN, I_CKROL, I_CGONIEC, I_CSKOCZEK, I_CWIEZA},
   {I_CPION , I_CPION   , I_CPION  , I_CPION  , I_CPION, I_CPION  , I_CPION   , I_CPION },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_BPION , I_BPION   , I_BPION  , I_BPION  , I_BPION, I_BPION  , I_BPION   , I_BPION },
   {I_BWIEZA, I_BSKOCZEK, I_BGONIEC, I_BHETMAN, I_BKROL, I_BGONIEC, I_BSKOCZEK, I_BWIEZA}};

// pozycja testowa
const char TPos[8][8] =
  {{I_PUSTE , I_PUSTE   , I_BKROL  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_BPION   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_CPION  , I_BHETMAN, I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_CPION , I_CWIEZA  , I_CPION  , I_PUSTE  , I_PUSTE, I_BWIEZA , I_CPION   , I_CPION },
   {I_CPION , I_PUSTE   , I_CKROL  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_CGONIEC , I_BWIEZA},
   {I_BPION , I_PUSTE   , I_PUSTE  , I_CWIEZA , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_BPION , I_CSKOCZEK, I_PUSTE  , I_PUSTE  , I_PUSTE, I_CPION  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_BSKOCZEK, I_PUSTE, I_BGONIEC, I_PUSTE   , I_PUSTE }};
const char T2Pos[8][8] =
  {{I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_CPION },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_CPION  , I_PUSTE   , I_CKROL },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_BKROL  , I_BHETMAN , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE }};
const char T3Pos[8][8] =
  {{I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_BPION  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_BKROL, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_PUSTE },
   {I_PUSTE , I_PUSTE   , I_PUSTE  , I_PUSTE  , I_PUSTE, I_PUSTE  , I_PUSTE   , I_CKROL }};

// ----------------------------------------------

EKolor KolorPrzeciwny(EKolor kolor)
{
  switch (kolor) {
  case C_CZARNE : return C_BIALE;
  case C_BIALE  : return C_CZARNE;
  }
  return C_BRAK;
}

EKolor KolorBierki(char	bierka)
{
  switch (bierka) {
  case I_PUSTE :
       return C_BRAK;
  case I_BPION:	case I_BWIEZA: case I_BSKOCZEK:
  case I_BGONIEC: case I_BHETMAN: case I_BKROL:
       return C_BIALE;
  case I_CPION:	case I_CWIEZA: case I_CSKOCZEK:
  case I_CGONIEC: case I_CHETMAN: case I_CKROL:
       return C_CZARNE;	
  }
  return C_BRAK;       // dummy return
}

// ----------------------------------------------
// konstruktory

// ten do woania CMoveInfo("E4", "D7")
CMoveInfo::CMoveInfo(char* src_move, char* dest_move)
{
  if (
       ( strlen(src_move) != 2 ) ||
       ( strlen(dest_move) != 2 )
     )
  {
    throw EMoveInfo_BADINITIALIZATION();
  }

  ys = src_move[0]-65;
  xs = src_move[1]-49;
  yd = dest_move[0]-65;
  xd = dest_move[1]-49;

  val = 0;

}

CSzachownica::CSzachownica()
{
  int i,j;
  for (i=0; i<8; i++)
    memset(bierki+i, I_PUSTE, 8);
}

CSzachownica::CSzachownica(const CSzachownica& szach)
{
  int i,j;
  for (i=0; i<8; i++)
    memcpy(bierki[i], szach.bierki[i], 8);
  k_ruch	   = szach.k_ruch;
  b_roszadakrotka  = szach.b_roszadakrotka;
  b_roszadadluga   = szach.b_roszadadluga;
  c_roszadakrotka  = szach.c_roszadakrotka;
  c_roszadadluga   = szach.c_roszadadluga;
  pm               = szach.pm;
  doremisu         = szach.doremisu;
  nr_pos           = szach.nr_pos;
}

// ----------------------------------------------

void CSzachownica::UstawieniePoczatkowe()
{
  int i,j;

  pm.xs = -10;	pm.ys	= -1;
  pm.xd = -1;   pm.yd   = -1;
  k_ruch = C_BIALE;
  nr_pos = 0;
  b_roszadakrotka = true;
  b_roszadadluga = true;
  c_roszadakrotka = true;
  c_roszadadluga = true;
  doremisu = 0;

  for (i=0; i<8; i++)
    for (j=0; j<8; j++)
      bierki[i][j] = SPos[7-i][j];
}


// ----------------------------------------------
void CSzachownica::PrzeciwnaStronaGra()
{
      if (k_ruch==C_BIALE)
	  k_ruch=C_CZARNE;
	  else
	  k_ruch=C_BIALE;
}

// ----------------------------------------------
// poniewaz w petli glownej operuje sie caly czas na tej samej
// planszy, wiec
// ta funkcja powinna:
// - zapamietac poprzedni ruch
// - ilosc ruchow do remisu
// - modyfikowac flagi roszowania

void CSzachownica::PrzesunBierke(CMoveInfo move)
{
   int xs = move.xs;
   int ys = move.ys;
   int xd = move.xd;
   int yd = move.yd;

   nr_pos++;

   char* bierka_s = &bierki[xs][ys];
   char* bierka_d = &bierki[xd][yd];

   // jesli nie ma bicia to licz ruchy do remisu
   if (*bierka_d == I_PUSTE) doremisu++; else doremisu = 0;

   // sprawdz czy bicie w przelocie, zabij tego piona ktory
   // ruszyl sie poprzednio
   char *bierka_pod = (xd == 2 ? &bierki[3][yd] : &bierki[4][yd]);
   if (
        (
          (*bierka_s == I_BPION && *bierka_pod == I_CPION) ||
          (*bierka_s == I_CPION && *bierka_pod == I_BPION)
        ) &&
        (pm.ys == yd) && (pm.yd == yd) &&
        (pm.xd == xs) &&
        (xd == 2 || xd == 5)
      )
      *bierka_pod = I_PUSTE;

   // wlasciwe przesuniecie !!

   // zapamietaj ostatnie posuniecie
   pm.xs = xs; pm.xd = xd;
   pm.ys = ys; pm.yd = yd;

   // przesun bierke na nowe miejsce
   *bierka_d = *bierka_s;
   *bierka_s = I_PUSTE;

   // ! testy przypadkow szczegolnych !

   // sprawdz czy promocja piona
   if (
        (xs == 6 && xd == 7 && *bierka_d == I_BPION) ||
        (xs == 1 && xd == 0 && *bierka_d == I_CPION)
      )
      if (move.nacopromowac != I_PUSTE)
      {
        *bierka_d = move.nacopromowac;
      }

   // sprawdz czy to roszada i ew. przesun wieze
   if (
        ys == 4 && yd == 2 &&
        (
          (xs == 0 && *bierka_d == I_BKROL) ||
          (xs == 7 && *bierka_d == I_CKROL)
        )
      )
   {
     bierki[xs][3] = (xs == 0 ? I_BWIEZA : I_CWIEZA);
     bierki[xs][0] = I_PUSTE;
   }
   if (
        ys == 4 && yd == 6 &&
        (
          (xs == 0 && *bierka_d == I_BKROL) ||
          (xs == 7 && *bierka_d == I_CKROL)
        )
      )
   {
     bierki[xs][5] = (xs == 0 ? I_BWIEZA : I_CWIEZA);
     bierki[xs][7] = I_PUSTE;
   }

   // sprawdz czy ruch wiezami lub krolami aby uniemozliwic roszady
   // w przyszlosci
   if (*bierka_d == I_BKROL && xs == 0 && ys ==	4)
     b_roszadakrotka = b_roszadadluga =	false;
   if (*bierka_d == I_BWIEZA &&	xs == 0	&& ys == 0)
     b_roszadadluga = false;
   if (*bierka_d == I_BWIEZA &&	xs == 0	&& ys == 7)
     b_roszadakrotka = false;
   if (*bierka_d == I_CKROL && xs == 7 && ys ==	4)
     c_roszadakrotka = c_roszadadluga =	false;
   if (*bierka_d == I_CWIEZA &&	xs == 7	&& ys == 0)
     c_roszadadluga = false;
   if (*bierka_d == I_CWIEZA &&	xs == 7	&& ys == 7)
     c_roszadakrotka = false;

}

// ----------------------------------------------

int CSzachownica::ZnajdzWspolrzedneKrola(bool s_ruch)
{
  int i,j;
  char c_szuka = ( ( (this->k_ruch == C_BIALE && s_ruch == true) ||
                     (this->k_ruch == C_CZARNE && s_ruch == false)
                   )
                   ? I_BKROL : I_CKROL
                 );
  for (i=0; i<8; i++)
    for (j=0; j<8; j++)
      if (this->bierki[i][j] == c_szuka)
        return i*8+j;
  return -1;

}

int CSzachownica::ZnajdzWspolrzedneKrolaEval(EKolor kolor)
{
  int i,j;
  char c_szuka = ( kolor == C_BIALE ? I_BKROL : I_CKROL );
  for (i=0; i<8; i++)
    for (j=0; j<8; j++)
      if (this->bierki[i][j] == c_szuka)
        return i*8+j;
  return -1;

}

// ----------------------------------------------

bool CSzachownica::CzyPoleJestPodBiciem(int x, int y,
                                        COpisRuchu* orh, bool s_ruch)
{
  int i;

  if (x<0 || x>8 || y<0 || y>8) return false;

  for (i=0; i<8*8; i++)
    if ( this->CzyRuchPoprawny(CMoveInfo(i/8, i%8, x, y, I_PUSTE),
                               orh, s_ruch, false) == MOVE_OK )
       return true;

  return false;
}

// ----------------------------------------------
bool CSzachownica::CzyJestPat(COpisRuchu* orh)
{
  CNode *root;
  bool sadzieci;

  root = KolejneRuchy(this, orh, true);

  sadzieci = (root->CountChildren() > 0);
   
  root->RemoveChildren();

  delete root;

  if (sadzieci) return false;
  return true;
}
// ----------------------------------------------
bool CSzachownica::CzyJestSzach(COpisRuchu* orh)
{
  // szukaj krola tego ktory mialby sie ruszac
//  static int ala;
//  gotoxy(60, 1);
//  cprintf("%d", ala++);

  int pk = this->ZnajdzWspolrzedneKrola(true);
  if (pk>=0)
    return this->CzyPoleJestPodBiciem(pk/8, pk%8, orh, false);
    else
    return false;
}
// ----------------------------------------------
bool CSzachownica::CzyJestMat(COpisRuchu* orh)
{
  CNode *root, *tmproot, *tmp, *tmp2;

  bool res;

  root = KolejneRuchy(this, orh, true);

  // tworz galezie 2 poziomu
  tmp = root->children;
  while (tmp!=NULL)
  {
//    ((CSzachownica*)tmp->el)->PrzeciwnaStronaGra();
    tmproot = KolejneRuchy((CSzachownica*)tmp->el, orh, true);
    tmp->children = tmproot->children;
    delete tmproot;

    tmp = tmp->next;
  }

  // przeszukaj liscie na poziomie 2. jesli wszedzie nie ma krola to jest MAT!

  res = true;           // zakladamy ze jest mat

  tmp = root->children;
  while (tmp!=NULL && res == true)
  {
    tmp2 = tmp->children;
    while (tmp2!=NULL && res == true)
    {
      if (
           // jesli krol istnieje choc raz, to znaczy ze jest
           // sciezka ucieczki od szacha!
           // funkcji CzyJestSzach() chyba nie da sie tak samo
           // napisac!
           ((CSzachownica*)tmp2->el)->ZnajdzWspolrzedneKrola(false) != -1
         )
      res = false;
      tmp2 = tmp2->next;
    }
    tmp = tmp->next;
  }
   
  root->RemoveChildren();

  delete root;

  return res;
}
// ----------------------------------------------

// sprawdza czy ruch jest zgodny z regulami
// s_ruch (standardowy ruch) =
//    true - ruch zgodny z tym na kogo teraz przypada ruch (k_ruch)
//    false - ruch przeciwny (przydatne przy testowaniu czy pole jest
//            szachowane
// n_test - true, sprawdza te czy nie ma szacha
//          false, nie sprawdza czy jest szach
// zwraca : 0 - ruch jest poprawny

MoveStatus CSzachownica::CzyRuchPoprawny(CMoveInfo move,
				  COpisRuchu* orh,
				  bool s_ruch, bool n_test)
{
   int xs = move.xs;
   int ys = move.ys;
   int xd = move.xd;
   int yd = move.yd;

   int sposV, dposV, i;	   // zrodlowa i docelowa pozycja w tablicy COpisRuchu
   int dx, dy, tempx, tempy;  // przyrosty przy badaniu przeskakiwania

   char	bierka = bierki[xs][ys];
   char	bierkad	= bierki[xd][yd];

   if (bierka == I_PUSTE) return MOVE_BRAKBIERKI;

   // bierka ma wartosc parzysta - biala, nieparzysta - czarna
   // stad bierka%2 ma taka sama wartosc jak k_ruch czyli [0,1]
   if (
        ( (bierka%2) != k_ruch && s_ruch == true) ||
        ( (bierka%2) == k_ruch && s_ruch == false)
      ) return MOVE_ZLYKOLOR;

   // indeksy w tablicy dobrych posuniec

   sposV = xs*8 + ys ;
   dposV = xd*8 + yd ;

   char orhSV = orh->SValidMoves[bierka][sposV][dposV];

   // badaj poprawnosc wedle zasad

   // w ogole nie ma takiej mozliwosci
   if (orhSV == VM_RUCHNIEMOZ)
     return MOVE_WBREWZASAD;
   
   // ruch jest dopuszczalny gdy jest wolne pole
   if (  (bierkad!=I_PUSTE) &&
         (orhSV & VM_GDYWOLNE) &&
       (!(orhSV & VM_GDYWROGA)) &&
       (!(orhSV & VM_ROSZADAK)) &&
       (!(orhSV & VM_ROSZADAD))
      )
      return MOVE_JESTTAMBIERKA;
   
   // proba zbicia pustego pola
   if (
         (bierkad==I_PUSTE) &&
         (orhSV & VM_GDYWROGA) &&
       (!(orhSV & VM_GDYWOLNE)) &&
       (!(orhSV & VM_PRZELOT))
      )
      return MOVE_BRAKBICIA;
   
   // proba zbicia wlasnej bierki
   if (
       (bierkad!=I_PUSTE) &&
       (bierka%2 == bierkad%2) //&&
//       (orhSV & VM_GDYWROGA)
      )
      return MOVE_BIJEWLASNA;
   
   // niepoprawne bicie w przelocie
   if ( bierka == I_BPION || bierka == I_CPION )
   if (
       (orhSV & VM_PRZELOT) &&
       (bierkad == I_PUSTE)
      )
      {
         char bierka_pod = (xd == 2 ? bierki[3][yd]: bierki[4][yd]);
         if (
              (bierka == I_BPION && bierka_pod != I_CPION) ||
              (bierka == I_CPION && bierka_pod != I_BPION) ||
              (pm.ys != yd) || (pm.yd != yd) ||
              (pm.xd != xs) ||
              (xd != 2 && xd != 5)
            )
            return MOVE_BRAKPRZELOTU;
      }

   // w przypadku piona, wiez, goncow i hetmanow trzeba zbadac
   // pola posrednie

   if ( (bierka	== I_BPION) || (bierka == I_CPION) ||
        (bierka	== I_BHETMAN) || (bierka == I_CHETMAN) ||
	(bierka	== I_BGONIEC) || (bierka == I_CGONIEC) ||
	(bierka	== I_BWIEZA) ||	(bierka	== I_CWIEZA) )
	{
	    if (xs<xd) dx = 1; else if (xs==xd)	dx = 0;	else dx	= -1;
	    if (ys<yd) dy = 1; else if (ys==yd)	dy = 0;	else dy	= -1;
	    tempx = xs + dx;
	    tempy = ys + dy;
	    while ( (tempx!=xd) || (tempy!=yd) )
	    {
	      if (bierki[tempx][tempy] != I_PUSTE)
		return MOVE_NIEPRZESKAKUJ;
	      tempx += dx;
	      tempy += dy;
	    }

	}

   // no i sprawdz czy mozna roszowac
   // pozostaje sprawdzic, czy pola przejsciowe nie s szachowane!
   // w PrzesunBierke() bedzie przenoszona wieza i krol

   if (
	  (bierka == I_BKROL) &&
	  (orhSV & VM_ROSZADAK)
      )    // rozbite na dwa warunki zeby nie wyjsc poza zakres z tym +1, +2
      if (
           (this->bierki[sposV/8][sposV%8+1] != I_PUSTE) ||
           (this->bierki[sposV/8][sposV%8+2] != I_PUSTE) ||
           (this->CzyPoleJestPodBiciem(sposV/8, sposV%8, orh, false) == true) ||
           (this->CzyPoleJestPodBiciem(sposV/8, sposV%8+1, orh, false) == true) ||
           (this->CzyPoleJestPodBiciem(sposV/8, sposV%8+2, orh, false) == true) ||
           (this->bierki[sposV/8][sposV%8+3] != I_BWIEZA) ||
           (b_roszadakrotka == false)
         )
         return MOVE_NIEROSZADAKROTKA;

   if (
          (bierka == I_CKROL) &&
	  (orhSV & VM_ROSZADAK)
      )
      if (
           (this->bierki[sposV/8][sposV%8+1] != I_PUSTE) ||
           (this->bierki[sposV/8][sposV%8+2] != I_PUSTE) ||
           (this->CzyPoleJestPodBiciem(sposV/8, sposV%8, orh, false) == true) ||
           (this->CzyPoleJestPodBiciem(sposV/8, (sposV%8)+1, orh, false) == true) ||
           (this->CzyPoleJestPodBiciem(sposV/8, (sposV%8)+2, orh, false) == true) ||
           (this->bierki[sposV/8][sposV%8+3] != I_CWIEZA) ||
	   (c_roszadakrotka == false)
	 )
         return MOVE_NIEROSZADAKROTKA;

   if (
	(bierka == I_BKROL) &&
	(orhSV & VM_ROSZADAD)
      )
      if (
           (this->bierki[sposV/8][sposV%8-1] != I_PUSTE) ||
           (this->bierki[sposV/8][sposV%8-2] != I_PUSTE) ||
           (this->bierki[sposV/8][sposV%8-3] != I_PUSTE) ||
           (this->CzyPoleJestPodBiciem(sposV/8, sposV%8, orh, false) == true) ||
           (this->CzyPoleJestPodBiciem(sposV/8, (sposV%8)-1, orh, false) == true) ||
           (this->CzyPoleJestPodBiciem(sposV/8, (sposV%8)-2, orh, false) == true) ||
           (this->bierki[sposV/8][sposV%8-4] != I_BWIEZA) ||
	   (b_roszadadluga == false)
	 )
         return MOVE_NIEROSZADADLUGA;

   if (
	(bierka == I_CKROL) &&
	(orhSV & VM_ROSZADAD)
      )
      if (
           (this->bierki[sposV/8][sposV%8-1] != I_PUSTE) ||
           (this->bierki[sposV/8][sposV%8-2] != I_PUSTE) ||
           (this->bierki[sposV/8][sposV%8-3] != I_PUSTE) ||
           (this->CzyPoleJestPodBiciem(sposV/8, sposV%8, orh, false) == true) ||
           (this->CzyPoleJestPodBiciem(sposV/8, (sposV%8)-1, orh, false) == true) ||
           (this->CzyPoleJestPodBiciem(sposV/8, (sposV%8)-2, orh, false) == true) ||
           (this->bierki[sposV/8][sposV%8-4] != I_CWIEZA) ||
           (c_roszadadluga == false)
         )
         return MOVE_NIEROSZADADLUGA;

   // na koncu kawaleczek, ktory utworzy nowa szachownice
   // z teoretycznie wykonanym owym ruchem i stworzy liste
   // nastepstw przeciwnika. jesli w tej liscie nastepstw znajdzie sie
   // ruch ktory zbija krola, to ruchu nie wolno wykonac. mam nadzieje
   // ze to nie doprowadzi do jakichs nieskonczonych wywolan rekurencyjnych
   // (zeby sprawdzic czy ruch jest poprawny tez trzeba sprawdzic czy nie ma
   //  szacha itd.)

   if (n_test)
   {
      CSzachownica* tmp = new CSzachownica(*this);

      tmp->PrzesunBierke(move);
      tmp->PrzeciwnaStronaGra();

      CNode* root;

      root = KolejneRuchy(tmp, orh, false);

      // czy przeciwnik moze zbic mojego krola?
      bool res = SzukajKrolaNaLiscie(root, false);
   
      root->RemoveChildren();

      delete root;
      delete tmp;

      // tak, znaczitsja wlazi pod niedozwolona pozycje
      if (res == false) return MOVE_BRONSZACHA;

   }

   // wszystko sprawdzone!

   return MOVE_OK;

}

// funkcja wyszukuje najlepsze posuniecie
CMoveInfo CSzachownica::AI(COpisRuchu* orh,
                           CTranspTable* trans,
                           bool s_w, bool s_b)
{
  int i;

//  textbackground(BLACK);
//  textcolor(GREEN);

  CEwaluator* ev = new CEwaluator;
  CMoveInfo value;

  plyMove = CMoveInfo(-1, -1, -1, -1, I_PUSTE);

  if (
       (this->k_ruch == C_BIALE && s_w == true) ||
       (this->k_ruch == C_CZARNE && s_b == true)
     )
     {
        CEwaluator::pos_count = 0;
        CNode* root = new CNode();
        root->el = this;

        if ( rand()%4<1 )
        {
          trans->ClearTable();
          if ( this->nr_pos < 10 )
            WhaszujTabliceOtwarc(trans);
        }

        s = clock();
        
        for (main_depth=min_depth; main_depth<=max_depth; main_depth++)
        {
          value = ev->AlphaBeta(root, orh, trans,
                                main_depth, -INFTY, INFTY, &value);
//          value = ev->MTDf(root, orh, trans, main_depth, &value);
        }
        
        SpeedOutput();

        // kocz dziaanie
        delete root;
        root = NULL;

     }

  delete ev;

  return value;
}

void SpeedOutput()
{
        char speed[80];        
        clock_t e = clock();

        // output prdkoci w tej ramce co dopiski        
        HDC hdc = GetDC(hwnd);
        SetBkColor( hdc, GetSysColor(COLOR_BTNFACE) );
        SetTextAlign( hdc, TA_LEFT );
        sprintf(speed, 
                   "%d p, %3.1f s  ",
                   CEwaluator::pos_count,
                   (double)(1+e-s)/CLOCKS_PER_SEC
                );                
        TextOut(hdc, boardPosX + 15, 
                     boardPosY+10+8*bm.bmHeight + 2 + 2*15,
                     speed, strlen(speed)
                );             
                
        SetTextAlign( hdc, TA_RIGHT );                
        sprintf(speed, "   %6.1f p/s",
                   (double)CEwaluator::pos_count*CLOCKS_PER_SEC/(1+e-s)
                );   
        TextOut(hdc, boardPosX+10+8*bm.bmWidth - 15, 
                     boardPosY+10+8*bm.bmHeight + 2 + 2*15,
                     speed, strlen(speed)
                );             
                              
        DeleteDC(hdc);
}

// ----------------------------------------------
// wypisywanie
// ----------------------------------------------

int ImageIndex(char bierka, int i, int j)
{
   int index;
   
   switch (bierka) {
      case I_BPION:    index = BM_B_PION_B;break;
      case I_CPION:    index = BM_C_PION_B;break;
      case I_BWIEZA:   index = BM_B_WIEZA_B;break;
      case I_CWIEZA:   index = BM_C_WIEZA_B;break;
      case I_BSKOCZEK: index = BM_B_SKOCZEK_B;break;
      case I_CSKOCZEK: index = BM_C_SKOCZEK_B;break;
      case I_BGONIEC:  index = BM_B_GONIEC_B;break;
      case I_CGONIEC:  index = BM_C_GONIEC_B;break;
      case I_BHETMAN:  index = BM_B_HETMAN_B;break;
      case I_CHETMAN:  index = BM_C_HETMAN_B;break;
      case I_BKROL:    index = BM_B_KROL_B;break;
      case I_CKROL:    index = BM_C_KROL_B;break;
      case I_PUSTE:    index = BM_B_PUSTE;break;
   }
   
   if ( (i+j)%2 ) index++;
   
   return index;    
            
} 

void CSzachownica::WypiszHWND(HWND hwnd)
{
     int i, j;
     int xs, ys, xd, yd;
     char lit[2];
     
     HDC hdc = GetDC(hwnd);
     
     HDC hdcMemory;
     hdcMemory = CreateCompatibleDC(hdc);

     // literki
     SetBkColor( hdc, GetSysColor(COLOR_BTNFACE) );
     
     for (i=0; i<8; i++)
     {
       sprintf(lit, "%c", i+65);
       TextOut(hdc, 
               boardPosX+i*bm.bmWidth+15, 0,
               lit, 1);
       sprintf(lit, "%c", 7-i+49);
       TextOut(hdc, 
               0, boardPosY+i*bm.bmHeight+12,
               lit, 1);
     }  

     // ramka
     HPEN hPen3, hPen1, hPenRed3, hPenBlue3;
     hPen1 = CreatePen (PS_SOLID, 1, 1) ;
     hPen3 = CreatePen (PS_SOLID, 3, 0) ;
     hPenRed3 = CreatePen (PS_DOT, 2, RGB(255, 0, 0)) ;
     hPenBlue3 = CreatePen (PS_DOT, 2, RGB(0, 0, 255)) ;
    
     SelectObject(hdc, hPen3);
     Rectangle (hdc, boardPosX, boardPosY, 
                     boardPosX+10+8*bm.bmWidth, 
                     boardPosY+10+8*bm.bmHeight ) ;

     SelectObject(hdc, hPen1);
     Rectangle(hdc, boardPosX+3, boardPosY+3, 
                    boardPosX+7+8*bm.bmWidth, 
                    boardPosY+7+8*bm.bmHeight);
     
     for (i=0; i<8; i++)
        for (j=0; j<8; j++)
        {
           SelectObject( hdcMemory, 
                         hbmPieces[ ImageIndex(bierki[7-j][i], i, j) ]
                       );
           BitBlt(hdc, boardPosX+5+i*bm.bmWidth, 
                       boardPosY+5+j*bm.bmHeight, 
                       bm.bmWidth, bm.bmHeight, 
                       hdcMemory, 0, 0, SRCCOPY);
        }   
                
     SelectObject(hdc, hPenRed3);
     SelectObject (hdc, GetStockObject (NULL_BRUSH) ) ;     

     xs = plyMove.ys; ys = 7-plyMove.xs;
     xd = plyMove.yd; yd = 7-plyMove.xd;

     if ( 
          (xs >= 0) && (xs < 8) && 
          (ys >= 0) && (ys < 8) 
        )
       Rectangle(hdc, boardPosX+5+xs*bm.bmWidth, 
                      boardPosY+5+ys*bm.bmHeight, 
                      boardPosX+5+(xs+1)*bm.bmWidth, 
                      boardPosY+5+(ys+1)*bm.bmHeight);

     SelectObject(hdc, hPenBlue3);
       
     if ( 
          (xd >= 0) && (xd < 8) && 
          (yd >= 0) && (yd < 8) 
        )
       Rectangle(hdc, boardPosX+5+xd*bm.bmWidth, 
                      boardPosY+5+yd*bm.bmHeight, 
                      boardPosX+5+(xd+1)*bm.bmWidth, 
                      boardPosY+5+(yd+1)*bm.bmHeight);
                      
        
     DeleteObject(hPen1);   
     DeleteObject(hPen3);
     DeleteObject(hPenRed3);
     DeleteObject(hPenBlue3);

     DeleteDC(hdcMemory);  
     DeleteDC(hdc); 
}

void CSzachownica::Dopiski(COpisRuchu* orh)
{
  int pxDop, pyDop, pxDopE, pyDopE;
  char buf[80];

  CMoveInfo value;  
  CEwaluator* ev = new CEwaluator;
  
  HDC hdc = GetDC(hwnd); 
  HPEN pen = CreatePen( PS_SOLID, 3, 0 ) ;
  
  SetBkColor( hdc, GetSysColor(COLOR_BTNFACE) );
  SelectObject (hdc, GetStockObject (NULL_BRUSH) ) ;     
  SelectObject (hdc, pen);
 
  pxDop  = boardPosX; 
  pyDop  = boardPosY+10+8*bm.bmHeight;
  pxDopE = boardPosX+10+8*bm.bmWidth;
  pyDopE = boardPosY+10+8*bm.bmHeight + 55;
 
  Rectangle (hdc, pxDop , pyDop ,
                  pxDopE, pyDopE ) ;

  sprintf( buf, "Td: %d     ", max_depth );
  TextOut( hdc, pxDop + 15 , pyDop + 2, buf, strlen(buf) );
  
  SetTextAlign( hdc, TA_RIGHT );
  sprintf( buf, "   Val: %6d", ev->Eval(this, orh) );
  TextOut( hdc, pxDopE - 15, pyDop + 2, buf, strlen(buf) );

  DeleteObject( pen );
  DeleteDC( hdc );

  delete ev;
}


