﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using SilverlightDTO.DTO;
using SilverlightDTOStudy.BusinessLayer;
using System.ServiceModel.Activation;

namespace SilverlightDTOStudy.Web
{
    [ServiceContract( Namespace = "http://test.com/Silverlight" )]
    [ServiceBehavior(
        InstanceContextMode = InstanceContextMode.PerCall, 
        ConcurrencyMode = ConcurrencyMode.Multiple,        
        UseSynchronizationContext = false )]
    [AspNetCompatibilityRequirements( RequirementsMode = AspNetCompatibilityRequirementsMode.Required )]
    public class SilverlightService 
    {
        [OperationContract]
        public DtoModel ExampleCall()
        {
            DtoModel modelDTO = new DtoModel();

            modelDTO.Children = new Dictionary<int, ChildDTO>();
            modelDTO.Parents = new Dictionary<int, ParentDTO>();

            /* insert children */
            foreach ( Child child in DataModel.Instance.Child.Take( 5 ) )
            {
                ChildDTO childDto = ChildDTO.ToDto( child );

                childDto.ExtendedProperties = new Dictionary<string, object>();
                childDto.ExtendedProperties.Add( "ParentName", child.Parent.Name );

                modelDTO.Children.Add( childDto.ID, childDto );

                ParentDTO parentDto = ParentDTO.ToDto( child.Parent );
                if ( !modelDTO.Parents.ContainsKey( parentDto.ID ) )
                    modelDTO.Parents.Add( parentDto.ID, parentDto );
            }

            return modelDTO;
        }
    }
}
