﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.ServiceModel;
using System.Reflection;
using System.IO;

namespace SilverlightDTOStudy.BusinessLayer
{
    public class DataModel
    {
        public const string MODELKEY = "model";
        public static TheDatabase Instance
        {
            get
            {
                if ( HttpContext.Current.Items[MODELKEY] == null )
                {
                    string DatabasePath = typeof( DataModel ).Assembly.CodeBase.Substring( 8 );
                    DatabasePath = Path.GetDirectoryName( DatabasePath );
                    DatabasePath = Path.Combine( DatabasePath, "TheDatabase.sdf" );

                    TheDatabase database = new TheDatabase( string.Format( "Data source={0}", DatabasePath ) );
                    HttpContext.Current.Items[MODELKEY] = database;
                }

                return (TheDatabase)HttpContext.Current.Items[MODELKEY];
            }
        }
    }
}
