﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SilverlightDTO.DTO
{
    public class ChildDTO : BaseDTO
    {
        public int    ID { get; set; }
        public int?   ID_PARENT { get; set; }
        public string Name { get; set; }

        public ParentDTO Parent
        {
            get
            {
                if ( this.Model != null &&
                     this.Model.Parents != null
                    )
                    return this.Model.Parents[this.ID_PARENT.Value];

                return null;
            }
        }

#if SILVERLIGHT
#else

        public static ChildDTO ToDto( SilverlightDTOStudy.BusinessLayer.Child Child )
        {
            ChildDTO childDto = new ChildDTO();

            childDto.ID        = Child.ID;
            childDto.ID_PARENT = Child.ID_PARENT;
            childDto.Name      = Child.Name;

            return childDto;
        }

        public static SilverlightDTOStudy.BusinessLayer.Child FromDto( ChildDTO ChildDto )
        {
            SilverlightDTOStudy.BusinessLayer.Child child = new SilverlightDTOStudy.BusinessLayer.Child();

            child.ID        = ChildDto.ID;
            child.ID_PARENT = ChildDto.ID_PARENT;
            child.Name      = ChildDto.Name;

            return child;
        }

#endif

    }
}
